/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.Util;
import java.util.ArrayList;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;

public class UtilTest {
    @Test
    public void testWrappers() {
        short[] s = new short[]{1, 2, 3, 4};
        Short[] s2 = Util.boxArr(s);
        short[] s3 = Util.unboxArr(s2);
        Assert.assertEquals((long)s.length, (long)s2.length);
        Assert.assertEquals((long)s.length, (long)s3.length);
        int i = 0;
        while (i < s.length) {
            Assert.assertEquals((long)s[i], (long)s2[i].shortValue());
            Assert.assertEquals((long)s[i], (long)s3[i]);
            ++i;
        }
        int[] i4 = new int[]{1, 2, 3, 4, Integer.MAX_VALUE, Integer.MIN_VALUE};
        Integer[] i2 = Util.boxArr(i4);
        int[] i3 = Util.unboxArr(i2);
        Assert.assertEquals((long)i4.length, (long)i2.length);
        Assert.assertEquals((long)i4.length, (long)i3.length);
        int x = 0;
        while (x < s.length) {
            Assert.assertEquals((long)i4[x], (long)i2[x].intValue());
            Assert.assertEquals((long)i4[x], (long)i3[x]);
            ++x;
        }
        long[] l = new long[]{1L, 2L, 3L, 4L, Integer.MAX_VALUE, Integer.MIN_VALUE, Long.MAX_VALUE, Long.MIN_VALUE};
        Long[] l2 = Util.boxArr(l);
        long[] l3 = Util.unboxArr(l2);
        Assert.assertEquals((long)l.length, (long)l2.length);
        Assert.assertEquals((long)l.length, (long)l3.length);
        int x2 = 0;
        while (x2 < s.length) {
            Assert.assertEquals((long)l[x2], (long)l2[x2]);
            Assert.assertEquals((long)l[x2], (long)l3[x2]);
            ++x2;
        }
        float[] f = new float[]{1.0f, 2.0f, 3.0f, 4.0f, 0.4f, 0.1f, Float.MAX_VALUE, Float.MIN_NORMAL};
        Float[] f2 = Util.boxArr(f);
        float[] f3 = Util.unboxArr(f2);
        Assert.assertEquals((long)f.length, (long)f2.length);
        Assert.assertEquals((long)f.length, (long)f3.length);
        int x3 = 0;
        while (x3 < s.length) {
            Assert.assertEquals((double)f[x3], (double)f2[x3].floatValue(), (double)1.0E-5);
            Assert.assertEquals((double)f[x3], (double)f3[x3], (double)1.0E-5);
            ++x3;
        }
        double[] d = new double[]{1.0, 2.0, 3.0, 4.0, 0.4, 0.1, 3.4028234663852886E38, 1.4E-45f, Double.MAX_VALUE, Double.MIN_NORMAL};
        Double[] d2 = Util.boxArr(d);
        double[] d3 = Util.unboxArr(d2);
        Assert.assertEquals((long)d.length, (long)d2.length);
        Assert.assertEquals((long)d.length, (long)d3.length);
        int x4 = 0;
        while (x4 < s.length) {
            Assert.assertEquals((double)d[x4], (double)d2[x4], (double)1.0E-5);
            Assert.assertEquals((double)d[x4], (double)d3[x4], (double)1.0E-5);
            ++x4;
        }
        char[] cArray = new char[9];
        cArray[0] = '\u0001';
        cArray[1] = 2;
        cArray[2] = 3;
        cArray[3] = 4;
        cArray[4] = 97;
        cArray[5] = 98;
        cArray[6] = 46;
        cArray[7] = 65535;
        char[] c = cArray;
        Character[] c2 = Util.boxArr(c);
        char[] c3 = Util.unboxArr(c2);
        Assert.assertEquals((long)c.length, (long)c2.length);
        Assert.assertEquals((long)c.length, (long)c3.length);
        int x5 = 0;
        while (x5 < s.length) {
            Assert.assertEquals((long)c[x5], (long)c2[x5].charValue());
            Assert.assertEquals((long)c[x5], (long)c3[x5]);
            ++x5;
        }
    }

    @Test
    public void testRandElement() {
        Assert.assertTrue((Util.randomElement(null) == null ? 1 : 0) != 0);
        HashSet<Integer> s = new HashSet<Integer>();
        Assert.assertTrue((Util.randomElement(s) == null ? 1 : 0) != 0);
        int i = 0;
        while (i < 10) {
            s.add(i);
            ++i;
        }
        HashSet<Integer> s2 = new HashSet<Integer>();
        while (!s2.equals(s)) {
            Integer i2 = (Integer)Util.randomElement(s);
            s2.add(i2);
            Assert.assertTrue((boolean)s.contains(i2));
        }
    }

    @Test
    public void testPermute() {
        ArrayList<Integer[]> a = Util.permute(new Integer[]{1, 2, 3, 4});
        Assert.assertEquals((long)a.size(), (long)24L);
        for (Integer[] i : a) {
            Assert.assertEquals((long)i.length, (long)4L);
            Assert.assertEquals((long)10L, (long)(i[0] + i[1] + i[2] + i[3]));
        }
        HashSet<Integer[]> s = new HashSet<Integer[]>(a);
        Assert.assertEquals((long)s.size(), (long)24L);
        a = Util.permute(new Integer[0]);
        Assert.assertEquals((long)a.size(), (long)1L);
    }
}

