/*
 * Decompiled with CFR 0.152.
 */
package common;

import java.util.HashSet;
import java.util.Iterator;

public class StringUtil {
    private static final HashSet<Character> breakCharacters = new HashSet();

    static {
        breakCharacters.add(Character.valueOf(' '));
        breakCharacters.add(Character.valueOf('_'));
        breakCharacters.add(Character.valueOf('-'));
        breakCharacters.add(Character.valueOf('.'));
        breakCharacters.add(Character.valueOf('/'));
        breakCharacters.add(Character.valueOf('\\'));
    }

    private StringUtil() {
    }

    public static String toPronounCase(String s) {
        char[] arr;
        if (s == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean capitalize = true;
        char[] cArray = arr = s.toLowerCase().toCharArray();
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (capitalize) {
                sb.append(Character.toUpperCase(c));
                capitalize = false;
            } else {
                sb.append(c);
            }
            capitalize = breakCharacters.contains(Character.valueOf(c));
            ++n2;
        }
        return sb.toString();
    }

    public static CharIterator charIterator(String s) {
        return new CharIterator(s);
    }

    public static class CharIterator
    implements Iterator<Character> {
        public final String source;
        private final char[] sourceArr;
        private int index;

        public CharIterator(String source) {
            this.source = source;
            this.sourceArr = source.toCharArray();
            this.index = 0;
        }

        public int currentIndex() {
            return this.index;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.sourceArr.length;
        }

        @Override
        public Character next() {
            return Character.valueOf(this.sourceArr[this.index++]);
        }
    }
}

