/*
 * Decompiled with CFR 0.152.
 */
package common;

import functional.TriConsumer;
import functional.TriFunction;
import functional.Unit;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.junit.Assert;

public class JUnitUtil {
    private JUnitUtil() {
    }

    public static void shouldFail(Unit request) {
        JUnitUtil.shouldFail(request, Throwable.class);
    }

    public static <E extends Throwable> void shouldFail(Unit request, Class<E> expectedException) {
        boolean got = false;
        Exception ex = null;
        try {
            request.apply();
            got = true;
        }
        catch (Exception e) {
            ex = e;
        }
        if (got) {
            Assert.fail((String)(request + " did not fail"));
        }
        if (!expectedException.isAssignableFrom(ex.getClass())) {
            Assert.fail((String)(request + " failed, but with exception " + ex + ". Expected " + expectedException));
        }
    }

    public static <T> void shouldFail(Supplier<T> request) {
        JUnitUtil.shouldFail(request, Throwable.class);
    }

    public static <T, E extends Throwable> void shouldFail(Supplier<T> request, Class<E> expectedException) {
        boolean got = false;
        Exception ex = null;
        Object t = null;
        try {
            t = request.get();
            got = true;
        }
        catch (Exception e) {
            ex = e;
        }
        if (got) {
            Assert.fail((String)(request + " did not fail. Got " + t));
        }
        if (!expectedException.isAssignableFrom(ex.getClass())) {
            Assert.fail((String)(request + " failed, but with exception " + ex + ". Expected " + expectedException));
        }
    }

    public static <T> void shouldFail(Consumer<T> request, T arg) {
        JUnitUtil.shouldFail(request, arg, Throwable.class);
    }

    public static <T, E extends Throwable> void shouldFail(Consumer<T> request, T arg, Class<E> expectedException) {
        boolean got = false;
        Exception ex = null;
        try {
            request.accept(arg);
            got = true;
        }
        catch (Exception e) {
            ex = e;
        }
        if (got) {
            Assert.fail((String)(request + " did not fail. Got"));
        }
        if (!expectedException.isAssignableFrom(ex.getClass())) {
            Assert.fail((String)(request + " failed, but with exception " + ex + ". Expected " + expectedException));
        }
    }

    public static <T, R> void shouldFailOn(Function<T, R> request, T arg) {
        JUnitUtil.shouldFailOn(request, arg, Throwable.class);
    }

    public static <T, R, E extends Throwable> void shouldFailOn(Function<T, R> request, T arg, Class<E> expectedException) {
        boolean got = false;
        Exception ex = null;
        Object r = null;
        try {
            r = request.apply(arg);
            got = true;
        }
        catch (Exception e) {
            ex = e;
        }
        if (got) {
            Assert.fail((String)(request + " did not fail. Got " + r));
        }
        if (!expectedException.isAssignableFrom(ex.getClass())) {
            Assert.fail((String)(request + " failed, but with exception " + ex + ". Expected " + expectedException));
        }
    }

    public static <T, R> void shouldFail(BiConsumer<T, R> request, T arg1, R arg2) {
        JUnitUtil.shouldFail(request, arg1, arg2, Throwable.class);
    }

    public static <T, R, E extends Throwable> void shouldFail(BiConsumer<T, R> request, T arg1, R arg2, Class<E> expectedException) {
        boolean got = false;
        Exception ex = null;
        try {
            request.accept(arg1, arg2);
            got = true;
        }
        catch (Exception e) {
            ex = e;
        }
        if (got) {
            Assert.fail((String)(request + " did not fail"));
        }
        if (!expectedException.isAssignableFrom(ex.getClass())) {
            Assert.fail((String)(request + " failed, but with exception " + ex + ". Expected " + expectedException));
        }
    }

    public static <T, R, S> void shouldFailOn(BiFunction<T, R, S> request, T arg1, R arg2) {
        JUnitUtil.shouldFailOn(request, arg1, arg2, Throwable.class);
    }

    public static <T, R, S, E extends Throwable> void shouldFailOn(BiFunction<T, R, S> request, T arg1, R arg2, Class<E> expectedException) {
        boolean got = false;
        Exception ex = null;
        Object s = null;
        try {
            s = request.apply(arg1, arg2);
            got = true;
        }
        catch (Exception e) {
            ex = e;
        }
        if (got) {
            Assert.fail((String)(request + " did not fail. Got " + s));
        }
        if (!expectedException.isAssignableFrom(ex.getClass())) {
            Assert.fail((String)(request + " failed, but with exception " + ex + ". Expected " + expectedException));
        }
    }

    public static <T, R, S> void shouldFail(TriConsumer<T, R, S> request, T arg1, R arg2, S arg3) {
        JUnitUtil.shouldFail(request, arg1, arg2, arg3, Throwable.class);
    }

    public static <T, R, S, E extends Throwable> void shouldFail(TriConsumer<T, R, S> request, T arg1, R arg2, S arg3, Class<E> expectedException) {
        boolean got = false;
        Exception ex = null;
        try {
            request.apply(arg1, arg2, arg3);
            got = true;
        }
        catch (Exception e) {
            ex = e;
        }
        if (got) {
            Assert.fail((String)(request + " did not fail"));
        }
        if (!expectedException.isAssignableFrom(ex.getClass())) {
            Assert.fail((String)(request + " failed, but with exception " + ex + ". Expected " + expectedException));
        }
    }

    public static <T, R, S, Q> void shouldFailOn(TriFunction<T, R, S, Q> request, T arg1, R arg2, S arg3) {
        JUnitUtil.shouldFailOn(request, arg1, arg2, arg3, Throwable.class);
    }

    public static <T, R, S, Q, E extends Throwable> void shouldFailOn(TriFunction<T, R, S, Q> request, T arg1, R arg2, S arg3, Class<E> expectedException) {
        boolean got = false;
        Exception ex = null;
        Object q = null;
        try {
            q = request.apply(arg1, arg2, arg3);
            got = true;
        }
        catch (Exception e) {
            ex = e;
        }
        if (got) {
            Assert.fail((String)(request + " did not fail. Got " + q));
        }
        if (!expectedException.isAssignableFrom(ex.getClass())) {
            Assert.fail((String)(request + " failed, but with exception " + ex + ". Expected " + expectedException));
        }
    }
}

