/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.IDObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IDObjectTest {
    @Before
    public void setUp() throws Exception {
        IDObject.next_id.set(0);
    }

    @Test
    public void testID() {
        IDObject x;
        int i = 0;
        while (i < 10) {
            x = new IDObject();
            Assert.assertEquals((long)x.getID(), (long)i);
            Assert.assertEquals((long)IDObject.getNextID(), (long)(i + 1));
            ++i;
        }
        i = 0;
        while (i < 20) {
            x = new IDObject(i);
            Assert.assertEquals((long)x.getID(), (long)i++);
            Assert.assertEquals((long)IDObject.getNextID(), (long)10L);
            ++i;
        }
    }

    @Test
    public void testEqualityAndHashcode() {
        ArrayList<IDObject> arr = new ArrayList<IDObject>();
        ArrayList<IDObject> copArr = new ArrayList<IDObject>();
        int i = 0;
        while (i < 10) {
            arr.add(new IDObject());
            copArr.add(new IDObject(i));
            ++i;
        }
        i = 0;
        while (i < arr.size()) {
            Assert.assertTrue((boolean)((IDObject)arr.get(i)).equals(arr.get(i)));
            Assert.assertTrue((boolean)((IDObject)arr.get(i)).equals(copArr.get(i)));
            Assert.assertEquals((long)((IDObject)arr.get(i)).hashCode(), (long)((IDObject)copArr.get(i)).hashCode());
            Assert.assertFalse((boolean)((IDObject)arr.get(i)).equals(null));
            Assert.assertFalse((boolean)((IDObject)arr.get(i)).equals(arr.get((i + 1) % arr.size())));
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultithreadedUse() throws InterruptedException {
        IDMaker m;
        List objs = Collections.synchronizedList(new ArrayList());
        ArrayList<IDMaker> makers = new ArrayList<IDMaker>();
        int i = 0;
        while (i < 10) {
            m = new IDMaker();
            makers.add(m);
            m.lst = objs;
            m.start();
            ++i;
        }
        boolean done = false;
        while (!done) {
            done = true;
            Iterator iterator = makers.iterator();
            while (iterator.hasNext()) {
                IDMaker iDMaker = m = (IDMaker)iterator.next();
                synchronized (iDMaker) {
                    if (!m.done) {
                        done = false;
                        m.wait();
                    }
                }
            }
        }
        Assert.assertEquals((long)100L, (long)objs.size());
        Collections.sort(objs, new Comparator<IDObject>(){

            @Override
            public int compare(IDObject o1, IDObject o2) {
                return o1.getID() - o2.getID();
            }
        });
        int i2 = 0;
        while (i2 < 100) {
            Assert.assertEquals((long)((IDObject)objs.get(i2)).getID(), (long)i2);
            ++i2;
        }
    }

    private static class IDMaker
    extends Thread {
        private List<IDObject> lst;
        private boolean done;
        private static final int NUMB_ITERATIONS = 10;

        private IDMaker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.done = false;
            int i = 0;
            while (i < 10) {
                IDObject x = new IDObject();
                try {
                    Thread.sleep((long)(Math.random() * 10.0));
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                this.lst.add(x);
                ++i;
            }
            IDMaker iDMaker = this;
            synchronized (iDMaker) {
                this.done = true;
                this.notify();
            }
        }
    }
}

