/** example of diff between notify() and notifyAll().
 * From http
 * //stackoverflow.com/questions/37026/java-notify-vs-notifyall-all-over-again
 */
import java.util.Random;

/** An instance repeateddly sleeps for a random amount of time
 *  and then puts a random number into a buffer. */
public class Producer implements Runnable {

    private Dropbox dropbox;     // The buffer into which to place integers

    /** Constructor: an instance that used buffer d. */
    public Producer(Dropbox d) {
        dropbox= d;
    }

    /** Forever do this: sleep for a random amount of time (in 0..99) and
     * then put a random number from 0..9 into the buffer. */
    public void run() {
        Random random= new Random();
        while (true) {
            int number= random.nextInt(10);
            try {
                Thread.sleep(random.nextInt(100));
                dropbox.put(number);
            } catch (InterruptedException e) { }
        }
    }

}