import static org.junit.Assert.*;

import org.junit.Test;
import java.util.Iterator;
public class DLLTest {


    @Test
    public void testConstructor() {
        DLL<Integer> c= new DLL<Integer>();
        assertEquals("[]", c.toString());
        assertEquals("[]", c.toStringRev());
        assertEquals(0, c.size());
    }

    @Test
    /** Test add(V val) (and toStringRev() and size()) */
    public void testOneParameterAdd() {
        DLL<Integer> c= new DLL<Integer>();

        c.add(5);
        assertEquals("[5]", c.toString());
        assertEquals("[5]", c.toStringRev());
        assertEquals(1, c.size());

        c.add(17);
        assertEquals("[5, 17]", c.toString());
        assertEquals("[17, 5]", c.toStringRev());
        assertEquals(2, c.size());

        c.add(6);
        assertEquals("[5, 17, 6]", c.toString());
        assertEquals("[6, 17, 5]", c.toStringRev());
    }


    @Test
    /** Test get(int h) and getNode(int h). */
    public void testGet() {
        DLL<Integer> c= new DLL<Integer>();
        // Test throw an exception when arg is less than 0
        try {c.get(-1); fail();}
        catch (IndexOutOfBoundsException e) {}
        catch (Exception e) {fail();}

        c.add(5);		
        c.add(17);
        c.add(22);
        c.add(24);
        c.add(2);

        assertEquals(5, (int) c.get(0));
        assertEquals(17, (int) c.get(1));
        assertEquals(22, (int) c.get(2));
        assertEquals(24, (int)c.get(3));
        assertEquals(2, (int)c.get(4));

        // Test throw an exception when arg is less than 0
        try {c.get(-1); fail();}
        catch (IndexOutOfBoundsException e) {}
        catch (Exception e) {fail();}

        // Test throw an exception when arg is at least size of the list
        try {c.get(5); fail();}
        catch (IndexOutOfBoundsException e) {}
        catch (Exception e) {fail();}
    }

    @Test
    public void testSet() {
        DLL<Integer> c= new DLL<Integer>();
        c.add(5);		
        c.add(17);
        c.add(22);
        c.add(24);
        assertEquals("[5, 17, 22, 24]", c.toString());

        assertEquals(5, (int) c.set(0, 9));
        assertEquals("[9, 17, 22, 24]", c.toString());
        assertEquals("[24, 22, 17, 9]", c.toStringRev());
        assertEquals(4, c.size());

        assertEquals(17, (int) c.set(1, 4));
        assertEquals("[9, 4, 22, 24]", c.toString());
        assertEquals("[24, 22, 4, 9]", c.toStringRev());
        assertEquals(4, c.size());

        assertEquals(22, (int) c.set(2, 21));
        assertEquals("[9, 4, 21, 24]", c.toString());
        assertEquals("[24, 21, 4, 9]", c.toStringRev());
        assertEquals(4, c.size());

        assertEquals(24, (int) c.set(3, 22));
        assertEquals("[9, 4, 21, 22]", c.toString());
        assertEquals("[22, 21, 4, 9]", c.toStringRev());
        assertEquals(4, c.size());

        try {c.set(-1, 1000); fail();}
        catch (IndexOutOfBoundsException e) {}

        try {c.set(4, 500); fail();}
        catch (IndexOutOfBoundsException e) {}
    }

    @Test
    /** Test add(int h, V val) and insertBefore. */
    public void testTwoParameterAdd() {
        DLL<Integer> c= new DLL<Integer>();

        try {c.add(-1, 5); fail();}
        catch (IndexOutOfBoundsException e) {}
        catch (Exception e) {fail();}

        try {c.add(c.size()+1, 5); fail();}
        catch (IndexOutOfBoundsException e) {}
        catch (Exception e) {fail();}

        c.add(0, 5);
        assertEquals("[5]", c.toString());
        assertEquals("[5]", c.toStringRev());
        assertEquals(1, c.size());

        c.add(0, 22);
        assertEquals("[22, 5]", c.toString());
        assertEquals("[5, 22]", c.toStringRev());
        assertEquals(2, c.size());

        c.add(1, 17);
        assertEquals("[22, 17, 5]", c.toString());
        assertEquals("[5, 17, 22]", c.toStringRev());
        assertEquals(3, c.size());

        c.add(1, 15);
        assertEquals("[22, 15, 17, 5]", c.toString());
        assertEquals("[5, 17, 15, 22]", c.toStringRev());
        assertEquals(4, c.size());

        c.add(4, 6);
        assertEquals("[22, 15, 17, 5, 6]", c.toString());
        assertEquals("[6, 5, 17, 15, 22]", c.toStringRev());
        assertEquals(5, c.size());

        try {c.add(-6, 5); fail();}
        catch (IndexOutOfBoundsException e) {}

        try {c.add(c.size()+6, 5); fail();}
        catch (IndexOutOfBoundsException e) {}
        catch (Exception e) {fail();}
    }

    @Test
    public void testRemove() {
        DLL<Integer> c= new DLL<Integer>();

        c.add(5);
        // Delete only node
        assertEquals(5, (int) c.remove(0));
        assertEquals("[]", c.toString());
        assertEquals("[]", c.toStringRev());
        assertEquals(0, c.size());

        c.add(17);
        c.add(22);
        // Delete first node when more than one
        assertEquals(17, (int) c.remove(0));
        assertEquals("[22]", c.toString());
        assertEquals("[22]", c.toStringRev());
        assertEquals(1, c.size());

        c.add(25);
        // Delete last node when more than one
        assertEquals(25, (int) c.remove(1));
        assertEquals("[22]", c.toString());
        assertEquals("[22]", c.toStringRev());
        assertEquals(1, c.size());

        c.add(24);
        c.add(27);
        assertEquals("[22, 24, 27]", c.toString());
        // Delete middle node
        assertEquals(24, (int) c.remove(1));
        assertEquals("[22, 27]", c.toString());
        assertEquals("[27, 22]", c.toStringRev());
        assertEquals(2, c.size());

        try {c.remove(-1); fail();}
        catch (IndexOutOfBoundsException e) {}
        catch (Exception e) {fail();}

        try {c.remove(c.size()); fail();}
        catch (IndexOutOfBoundsException e) {}
        catch (Exception e) {fail();}
    }

    @Test
    public void testClassOtherThanInteger() {
        DLL<String> c= new DLL<String>();
        c.add("L");
        c.add("A");
        c.add(null);
        c.add("T");
        c.add("T");
        c.add("E");
        assertEquals("[L, A, null, T, T, E]", c.toString());
    }

    @Test
    public void testIterator() {
        DLL<Integer> ll= new DLL<Integer>();
        assertEquals("", useIterator(ll));

        ll.add(1); ll.add(8); ll.add(7);
        ll.add(5); ll.add(4); ll.add(3);
        assertEquals("1 8 7 5 4 3 ", useIterator(ll));
    }

    /** Return the enumeration of ll with a blank after each value,
     * using ll.iterator() */
    public static <V> String useIterator(DLL<V> ll) {
        String res= "";
        Iterator<V> it= ll.iterator();
        // invariant: res contains the values that have been
        //        enumerated so far, with a blank after each
        while (it.hasNext()) {
            res= res + it.next() + " ";
        }
        return res;
    }

    @Test
    public void testIterable() {
        DLL<Integer> ll= new DLL<Integer>();
        assertEquals("", useForEach(ll));

        ll.add(1); ll.add(8); ll.add(7);
        ll.add(5); ll.add(4); ll.add(3);
        assertEquals("1 8 7 5 4 3 ", useForEach(ll));
    }

    /** Return the enumeration of ll, with a blank after each value */
    public static <V> String useForEach(DLL<V> ll) {
        String res= "";
        // invariant: res contains the values that have been
        //        enumerated so far (with a blank after each)
        for (V elem : ll) {
            res= res + elem + " ";
        }
        return res;
    }


}
