package initial;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;

import javax.swing.*;

public class KeyDemo extends JFrame {
	
	private JLabel label;
	
	public KeyDemo() {
		super("Keyboard demo");
		this.label = new JLabel("");
		
		setPreferredSize(new Dimension(300,100));
		add(label, BorderLayout.CENTER);
		
		addKeyListener(new KeyAdapter() {
			public @Override void keyPressed(KeyEvent e) {
				label.setText(label.getText() + Character.toUpperCase(e.getKeyChar()));
			}
		});
		pack();
	}
	
	public static void main(String[] args) {
		new KeyDemo().setVisible(true);
	}
}
