package complete;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.*;

public class SquareDemo extends JFrame {

	public class Square extends JPanel implements MouseListener {
		private final int i, j;
		private boolean selected;
		
		public Square(int i, int j) {
			this.i = i; this.j = j;
			selected = false;
			setPreferredSize(new Dimension(100,100));
			addMouseListener(this);
		}
		
		public void toggle() {
			this.selected = !this.selected;
			repaint();
		}
		
		public @Override void paint(Graphics g) {
			if ((i + j) % 2 == 0)
				g.setColor(Color.GREEN);
			else
				g.setColor(Color.RED);
			
			g.fillRect(0, 0, getWidth()-1, getHeight()-1);
			
			g.setColor(Color.BLACK);
			g.drawRect(0, 0, getWidth()-1, getHeight()-1);
			
			if (selected) {
				g.setColor(Color.PINK);
				g.fillArc(0, 0, getWidth()-1, getHeight()-1, 0, 360);
			}
			
			g.setColor(Color.BLACK);
			g.drawString("(" + i + ", " + j + ")", 20, 20);
		}

		@Override
		public void mouseClicked(MouseEvent e) {
			toggle();
		}

		@Override
		public void mouseEntered(MouseEvent e) {
		}

		@Override
		public void mouseExited(MouseEvent e) {
		}

		@Override
		public void mousePressed(MouseEvent e) {
		}

		@Override
		public void mouseReleased(MouseEvent e) {
		}
	}
	
	public SquareDemo() {
		super("SquareDemo");
		
		JPanel center = new JPanel();
		center.setLayout(new GridLayout(3,3));
		for (int i = 0; i < 3; i++)
			for (int j = 0; j < 3; j++)
				center.add(new Square(i,j));
		
		add(center, BorderLayout.CENTER);
		pack();
	}
	
	public static void main(String[] args) {
		new SquareDemo().setVisible(true);
	}
}
