package complete;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.*;

public class EWDemo extends JFrame {
	
	JButton east, west;
	
	private class Listener implements ActionListener {
		@Override
		public void actionPerformed(ActionEvent e) {
			east.setEnabled(!east.isEnabled());
			west.setEnabled(!west.isEnabled());	
		}
	}
	
	public EWDemo() {
		super("East/West Demo");
		
		this.east = new JButton("East");
		this.west = new JButton("West");
		
		add(this.east, BorderLayout.EAST);
		add(this.west, BorderLayout.WEST);
		
		this.east.setEnabled(false);

		east.addActionListener(new Listener());
		west.addActionListener(new Listener());

		east.addActionListener(new ActionListener() {
			public @Override void actionPerformed(ActionEvent arg0) {
				System.out.println("east pressed");
			}
		});

		pack();
	}
	
	public static void main(String[] args) {
		new EWDemo().setVisible(true);
	}
}
