import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/** This class is used to demonstrate having different listeners for
    different buttons. Button westButton has the main class, BUttonDemo2, as
    its listener. Button eastButton has a private inner class, BEListener,
    as its listener.
    
    An instance has the same functionality as an instance of class
    ButtonDemo1.
  */
public class ButtonDemo2 extends JFrame implements ActionListener {
	// Class invariant: exactly one of eastButton and westButton is enabled
	private JButton westButton= new JButton("west");
	private JButton eastButton= new JButton("east");
	
	/** Constructor: an invisible frame with title t and two buttons */
	public ButtonDemo2(String t) {
		super(t);

        Container cp= getContentPane();
		cp.add(westButton,BorderLayout.WEST);
		cp.add(eastButton,BorderLayout.EAST);
	     
		westButton.setEnabled(false);
		eastButton.setEnabled(true);
	
		westButton.addActionListener(this);
		eastButton.addActionListener(new BeListener());
	
		pack();
	}
	       
	/** Process a click of a button */
	public void actionPerformed(ActionEvent e) {
		if (eastButton == e.getSource()) {
			System.out.println("eastButton");
		}
		boolean b= eastButton.isEnabled();
		eastButton.setEnabled(!b);
		westButton.setEnabled(b);
	}
	
	private class BeListener implements ActionListener {
		// Process a click of a button
		public void actionPerformed(ActionEvent e) {
			boolean b= eastButton.isEnabled();
			eastButton.setEnabled(!b);
			westButton.setEnabled(b);
		}
	}
	
	public static void main(String[] args) {
		ButtonDemo2 bd= new ButtonDemo2("demo buttons");
		bd.setVisible(true);
}
}