import javax.swing.*;
import java.awt.*;
import java.awt.event.*;


public class ButtonDemo3 extends JFrame
    implements ActionListener {
    private JButton westButton= new JButton("west");
    private JButton eastButton= new JButton("east");
    
    /** Constructor: inv frame with title t, two buttons */
    public ButtonDemo3(String t) {
        super(t);
        Container cp= getContentPane();
        cp.add(westButton,BorderLayout.WEST);
        cp.add(eastButton,BorderLayout.EAST);
        cp.add(new JLabel("   "), BorderLayout.SOUTH);
        cp.add(new JLabel("   "), BorderLayout.CENTER);
        cp.add(new JLabel("   "), BorderLayout.NORTH);
        westButton.setEnabled(false);
        eastButton.setEnabled(true);
        
        westButton.addActionListener(this);
        eastButton.addActionListener(this);
        
        
        pack();
        setVisible(true);
    }
    
    public void actionPerformed(ActionEvent e) {
        boolean b= eastButton.isEnabled();
        eastButton.setEnabled(!b);
        westButton.setEnabled(b);
        System.out.println("ButtonDemo3 actionPerformed");
    }
    
}


/** Step 1. Take the comment delimiters away from this class
  to show that it won't compile because the class doesn't
  have access to eastButton and westButton. After trying to compile,
  put comment delimiters back.
  class BeListener implements ActionListener {
  public void actionPerformed(ActionEvent e) {
  boolean b= eastButton.isEnabled();
  eastButton.setEnabled(!b);
  westButton.setEnabled(b);
  }
  }
  */

/** Step 2. Put this private class inside the class,
     as an inner class. Then change
        
        eastButton.addActionListener(this);
     to 
        eastButton.addActionListener(new BeListener());
        
private class BeListener implements ActionListener {
  public void actionPerformed(ActionEvent e) {
  boolean b= eastButton.isEnabled();
  eastButton.setEnabled(!b);
  westButton.setEnabled(b);
  }
  }
  */

/** Step 3. The following code adds an ActionListener to the eastButton using
  * an anonymous class. Go ahead and put it in after the other add-listener
  * statement for the eastButton. Note that the button will then call two
  * different actionPerformed methods, and the east button will stay enabled.
  * Until you comment out the first add-listener statement for the east button.
eastButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                boolean b= eastButton.isEnabled();
                eastButton.setEnabled(!b);
                westButton.setEnabled(b);
                System.out.println("anonymous class actionPerformed");
            }});
*/



