/** An executive: an employee with a bonus. */
public class Executive extends Employee {
    /** Yearly bonus */
    private double bonus;
    
    /** PRINCIPLE: ALWAYS INITIALIZE THE SUPERCLASS
      * FIELDS FIRST. 
      * 
      * If a constructor does not start with a
      * call on another constructor, Java inserts the
      * call
      *      super();
    
    /** Constructor: a person with name n, year hired d,
        salary 50,000, and bonus b */
    public Executive(String n, int d, double b) {
        super(n, d, 50000); // call of constructor in superclass
        bonus= b;
    }
    
    /** = this executive's yearly compensation:
          normal compensation + bonus */
    public @Override double getCompensation() {
        return super.getCompensation() + bonus; // call getCompensation in superclass
    }

    
    
    /** = this executive's bonus */
    public double getBonus() {
        return bonus; 
    }
    
     
    /** = a representation of this executive */
    public String toString() { 
        return super.toString() + ", bonus " + bonus; 
    }
}