/** An instance maintains a time of day */
public class Time { 
    private int hr;  // hour of the day, in 0..23
    private int min; // minute of the hour, in 0..59

    /** Return the hour of the day */
    public int getHour() {
        return hr;
    }

    /** Return the minute of the hour */
    public int getMinute() {
        return min;
    }

    /** Constructor: an instance with 0 hours and 0 minutes. */
    public Time() {
    }

    /** Constructor: an instance with h hours and m minutes. 
     * Precondition: h in 0..23 and m in 0..59. */
    public Time(int h, int m) {
        assert 0 <= h  && h <= 23;
        assert 0 <= m  && m <= 59;
        hr= h;
        min= m;
    }

    /** Constructor: an instance with m minutes.
    Precondition: m in 0..23*60 +59 */
    public Time(int m) {
        assert 0 <= m  &&  m <= 23*60 +59;
        hr= m / 60;
        min= m % 60;
    }

    /** Change the hour to h.
     * Precondition: h is in 0..23 */
    public void setHour(int h) {
        assert 0 <= h  && h <= 23;
        hr= h;
    }

    /** Return a representation of this time, e.g. 09:05.
     * Example shows that 2 digits should be used. */
    public String toString() {
        return prepend(hr) + ":" + prepend(min);
    }

    // The following method is private because it is used only
    // internally in writing the class. The user does not have to
    // know about it
    /** Return k as a string, prepended with
     * 0 if necessary so that it is at least 2 chars long*/
    private String prepend(int k) {
        if (0 <= k  && k < 10) {
            return "" + k;
        }
        return "0" + k;
    }

}
