import java.io.*;

import java.util.*;
import java.net.*;
import javax.swing.*;

/** Demo IO */
public class DemoIO {
    
    public static String courseLinksPage= 
               "http://www.cs.cornell.edu/courses/CS2110/2014sp/links.html";

    /** Demo IO stuff */
    public static void main(String[] pars) throws IOException {
        fileDec();   // Demo 1: File declaration and use.
        fileDirectory(); // Demo getting files in a directory
        
        int n= getSize(new File("res/map1.xml"));
        System.out.println("number of lines in map1.xml: " + n);
        
        URLlines(40, new URL(courseLinksPage));

        System.out.println("Finished writing URL lines: \n\n");
        
        
        BufferedReader d= getReader(null);
        if (d != null ) {
            System.out.println("Ready to read from File" +
                d); 
        }
    }

    /** Show a File declaration, print length of file, and absolute path */
    public static void fileDec() {
        File f= new File("res/map1.xml");
        System.out.println("length of File f is " + f.length());
        System.out.println("Absolute path is " + f.getAbsolutePath());
    }

    /** Demo the use of a file that is a directory */
    public static void fileDirectory() {
        File f= new File("res");
        if (f.isDirectory()) {
            File[] l= f.listFiles();
            System.out.println("files in res are: " + Arrays.toString(l));
        }
    }

    /** Return the number of lines in file f */
    public static int getSize(File f) throws IOException {
        FileReader fr= new FileReader(f);
        BufferedReader br= new BufferedReader(fr);
        int n= 0;  // number of lines read so far
        String line= br.readLine();
        // invariant: n is the number of lines read thus far, NOT
        //    counting the last line read, line.
        while (line != null) {
            n= n+1;
            line= br.readLine();
        }
        br.close(); 
        return n;
    }
    
    /** Print the first 30 lines of the html file given by URL */
    public static void URLlines(int n, URL url) throws IOException {
        InputStreamReader isr= new InputStreamReader(url.openStream());
        BufferedReader br = new BufferedReader(isr);
        String line= br.readLine();
        int h= 0;
        // invariant: h lines have been printed and line is the next
        //            one to print (if not null)
        while (h < n  &&  line != null) {
            System.out.println(line);
            h= h+1;
            line= br.readLine();
        }
        br.close();
        
        
    
    }
    
    /** Obtain a file name from the user using a JFileChooser)
    and return a reader that is linked to it. If the user cancels the
    dialog window and thus does not give a file name, return null.
    Parameter p can be a path on the hard drive or null. If p is not null,
    start the JFileChooser at the path given by p.*/
  public static BufferedReader getReader(String p) throws IOException {
      try {
          JFileChooser jd;
          if (p == null) {
              jd= new JFileChooser();
          }
          else {
              jd= new JFileChooser(p);
          }
          
          jd.setDialogTitle("Choose input file");
          int returnVal= jd.showOpenDialog(null);
          
          if (returnVal != JFileChooser.APPROVE_OPTION) {
              System.out.println("Dialog window canceled, or IO error");
              return null;
          }
          
          System.out.println("You chose file " + jd.getSelectedFile());
          FileReader fr= new FileReader(jd.getSelectedFile());
          return new BufferedReader(fr);
      }
      catch (IOException e) {
          return null;
      }
  }

}
