import java.util.*;

/** An instance represents a point in the plane, assumed to
    be subclassed to represent a shape at that place in the plane */
public abstract class Shape implements Comparable {
    private double x; // X coordinate of this shape in the plane
    private double y; // Y coordinate of this shape in the plane

    /** If c is not a Shape, throw a CastClass exception.
        Otherwise, return -1, 0, or 1 depending on whether this
        shape has a smaller area than c, the same area, or a greater area */
    public @Override int compareTo(Object c) {
        double diff = area() - ((Shape) c).area();
        if (diff == 0) return 0;
        if (diff > 0)  return 1;
        return -1;
    }

    /** Constructor: an instance at point (x, y) */
    public Shape(double x, double y) {
        this.x = x;
        this.y = y;
    }

    /** In a subclass, the area of the shape. */
    public abstract double area();

    /** return the point in the plane of this object */
    public @Override String toString() {
        return "(" + x + ", " + y + ")";
    }

}
