/*
 * Decompiled with CFR 0.152.
 */
class ThreeDPoint {
    double x;
    double y;
    double z;

    ThreeDPoint(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    ThreeDPoint plus(ThreeDPoint p) {
        return new ThreeDPoint(this.x + p.x, this.y + p.y, this.z + p.z);
    }

    ThreeDPoint minus(ThreeDPoint p) {
        return new ThreeDPoint(this.x - p.x, this.y - p.y, this.z - p.z);
    }

    double dotProduct(ThreeDPoint p) {
        return this.x * p.x + this.y * p.y + this.z * p.z;
    }

    double length() {
        return Math.sqrt(this.dotProduct(this));
    }

    double cos(ThreeDPoint p) {
        return this.dotProduct(p) / (this.length() * p.length());
    }

    TwoDPoint project(Matrix orientation, ThreeDPoint viewerPosition) {
        return orientation.transpose().mult(this).project(viewerPosition);
    }

    TwoDPoint project(ThreeDPoint viewerPosition) {
        double retinalDistance = 1.0;
        double alpha = 1.0 / (viewerPosition.x - this.x);
        return new TwoDPoint(this.y * alpha, this.z * alpha);
    }

    boolean visible(ThreeDPoint viewerPosition) {
        ThreeDPoint forward = new ThreeDPoint(-0.05, 0.0, 0.0);
        return forward.dotProduct(this.minus(viewerPosition.plus(forward))) >= 0.0;
    }
}

