/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Polygon;

class Square {
    ThreeDPoint center;
    ThreeDPoint normal;
    Color color;
    static final ThreeDPoint[][] baseCorners = new ThreeDPoint[][]{{new ThreeDPoint(0.0, 1.0, 1.0), new ThreeDPoint(0.0, -1.0, 1.0), new ThreeDPoint(0.0, -1.0, -1.0), new ThreeDPoint(0.0, 1.0, -1.0)}, {new ThreeDPoint(1.0, 0.0, 1.0), new ThreeDPoint(-1.0, 0.0, 1.0), new ThreeDPoint(-1.0, 0.0, -1.0), new ThreeDPoint(1.0, 0.0, -1.0)}, {new ThreeDPoint(1.0, 1.0, 0.0), new ThreeDPoint(-1.0, 1.0, 0.0), new ThreeDPoint(-1.0, -1.0, 0.0), new ThreeDPoint(1.0, -1.0, 0.0)}};
    ThreeDPoint[] corners = new ThreeDPoint[4];
    ThreeDPoint[] orientedCorners = new ThreeDPoint[4];
    ThreeDPoint[] truncatedCorners = new ThreeDPoint[5];

    Square(BSPTree t, ThreeDPoint center, ThreeDPoint normal, Color color) {
        this.center = center;
        this.normal = normal;
        this.color = color;
        int cornersIndex = normal.x != 0.0 ? 0 : (normal.y != 0.0 ? 1 : 2);
        for (int i = 0; i < 4; ++i) {
            this.corners[i] = center.plus(baseCorners[cornersIndex][i]);
        }
        t.insert(this);
    }

    Polygon project(Matrix orientation, ThreeDPoint viewerPosition) {
        int i;
        Polygon p = new Polygon();
        for (i = 0; i < 4; ++i) {
            this.orientedCorners[i] = orientation.transpose().mult(this.corners[i]);
        }
        for (i = 0; i < 4; ++i) {
            ThreeDPoint s;
            if (this.orientedCorners[i].visible(viewerPosition)) {
                this.orientedCorners[i].project(viewerPosition).place(p);
                continue;
            }
            if (this.orientedCorners[(i + 3) % 4].visible(viewerPosition)) {
                s = this.truncate(this.orientedCorners[(i + 3) % 4], this.orientedCorners[i], viewerPosition);
                s.project(viewerPosition).place(p);
            }
            if (!this.orientedCorners[(i + 1) % 4].visible(viewerPosition)) continue;
            s = this.truncate(this.orientedCorners[(i + 1) % 4], this.orientedCorners[i], viewerPosition);
            s.project(viewerPosition).place(p);
        }
        return p;
    }

    ThreeDPoint truncate(ThreeDPoint s, ThreeDPoint t, ThreeDPoint vp) {
        ThreeDPoint forward = new ThreeDPoint(-0.05, 0.0, 0.0);
        vp = vp.plus(forward);
        double a = vp.minus(t).dotProduct(vp);
        double b = s.minus(t).dotProduct(vp);
        double alpha = b == 0.0 ? 0.0 : a / b;
        double u = alpha * s.x + (1.0 - alpha) * t.x;
        double v = alpha * s.y + (1.0 - alpha) * t.y;
        double w = alpha * s.z + (1.0 - alpha) * t.z;
        return new ThreeDPoint(u, v, w);
    }

    boolean behind(ThreeDPoint p) {
        return p.minus(this.center).dotProduct(this.normal) >= 0.0;
    }
}

