package CS2110Stacks;

/** A stack is a list that follows the last-in-first-out (LIFO)
 * principle. An example is a stack of cafeteria trays. You take
 * the top one, which is the last one that the staff put in.<br><br>
 * Package CS2110Stacks contains this interface and three implementations:<br>
 * One uses an array; the second uses a linked list; and the third uses
 * a linked list but with no iteration, just recursion.<br><br>
 * In addition, to show how to do such things, each implementation
 * provides operation not usually found with stacks:<br><br>
 * 1. Delete the top occurrence of an element e (if present)<br>
 * 2. Tell whether the stack contains a particular element<br>
 * 3. Reverse the stack --turn it upside down.<br><br>
 * They are not included in this interface
 * because they are not typical stack operations. */
public interface Stack<T> {

   /** Push e on this stack. */
   public void push(T e);

   /** Pop the top element of this stack and return it.
    * Throw RuntimeException if the stack is empty */
   public T pop();

   /** Return true iff this stack contains e. */
   public boolean contains(T e);

   /** Return the number of elements in this stack. */
   public int size();
}

/** Stack cell (a helper class; visible to other classes in same package). */
class StackCell<T> {
   public T datum; // Data for this cell
   public StackCell<T> next; // Next cell in this Stack

   /** Constructor: an instance with datum d and next cell next. */
   public StackCell(T d, StackCell<T> next) {
      datum= d;
      this.next= next;
   }
}
