import java.io.*;
import java.util.*;
import java.net.*;

/** Demo IO */
public class DemoIO {
    
    public static String courseLinksPage= 
               "http://www.cs.cornell.edu/courses/CS2110/2013fa/links.html";

    /** Demo IO stuff */
    public static void main(String[] pars) throws IOException {
        fileDec();   // Demo 1: File declaration and use.
        fileDirectory(); // Demo getting files in a directory
        
        int n= getSize(new File("res/map1.xml"));
        System.out.println("number of lines in map1.xml: " + n);
        
        URLlines(40, new URL(courseLinksPage));
    }

    /** Show a File declaration, print length of file, and absolute path */
    public static void fileDec() {
        File f= new File("res/map1.xml");
        System.out.println("length of File f is " + f.length());
        System.out.println("Absolute path is " + f.getAbsolutePath());
    }

    /** Demo the use of a file that is a diectory */
    public static void fileDirectory() {
        File f= new File("res");
        if (f.isDirectory()) {
            File[] l= f.listFiles();
            System.out.println("files in res are: " + Arrays.toString(l));
        }
    }

    /** Return the number of lines in file f */
    public static int getSize(File f) throws IOException {
        FileReader fr= new FileReader(f);
        BufferedReader br= new BufferedReader(fr);
        int n= 0;  // number of lines read so far
        String line= br.readLine();
        // invariant: n is the number of lines read thus far, NOT
        //    counting the last line read, line.
        while (line != null) {
            n= n+1;
            line= br.readLine();
        }
        br.close(); 
        return n;
    }
    
    /** Print the first 30 lines of the html file given by URL */
    public static void URLlines(int n, URL url) throws IOException {
        InputStreamReader isr= new InputStreamReader(url.openStream());
        BufferedReader br = new BufferedReader(isr);
        String line= br.readLine();
        int h= 0;
        // invariant: h lines have been printed and line is the next
        //            one to print (if not null)
        while (h < n  &&  line != null) {
            System.out.println(line);
            h= h+1;
            line= br.readLine();
        }
        br.close();
        
        
    
    }

}
