/** An instance is a circle with radius at a pt in the plane */
public class Circle extends Shape {
    private double radius; // the radius of this circle

    /** Constructor: a Circle with radius r at (x, y).
        Precondition: r >= 0.   */
    public Circle(double r, double x, double y) {
        super(x, y);
        radius= r;
    }

    /** Return the area of the circle */
    public @Override double area() {
        return Math.PI*radius*radius;
    }

    /** Return representation of this Circle. */
    public @Override String toString() {
        return "Circle with radius " + radius + " at " + super.toString();
    }


}
