package otherGUIDemos;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/** This class is used to demo the listening of a return-key stroke
    and a button to make the text field into upper case letters.
  */
public class FieldDemo extends JFrame {
	private JButton b= new JButton("first");
	private JTextField jTF= new JTextField("type here", 20);
	
	/** Show the GUI  */
	public static void main(String[] args) {
        FieldDemo fd= new FieldDemo();
    }

	/** Constructor: an invisible frame with a button, 
	              and a text field  */
	public FieldDemo() {
		super("FieldDemo");
		getContentPane().add(b, BorderLayout.WEST);
		b.setEnabled(true);
	
		getContentPane().add(jTF, BorderLayout.EAST);
	
		// Set the actionlistener for components
			b.addActionListener(new MakeUpperCase());
			jTF.addActionListener(new MakeUpperCase());
	   
		pack();
		setVisible(true);
	}
	 
	/** Procedures actionPerformed changes characters in text
	    field jTF to upper case
	  */
	public class MakeUpperCase implements ActionListener {
	    public void actionPerformed(ActionEvent e) {
		    String x= jTF.getText();
		    jTF.setText(x.toUpperCase());
	    }
	}
}