/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;

class Figure
extends Frame {
    Cubes cubes = new Cubes();
    boolean fill = false;
    static final ThreeDPoint baseLightSource = new ThreeDPoint(10.0, 20.0, 30.0);
    double viewerDistance = 10.0;
    ThreeDPoint baseViewerPosition = new ThreeDPoint(this.viewerDistance, 0.0, 0.0);
    static final double minViewerDistance = Double.NEGATIVE_INFINITY;
    double distanceVelocity = 0.0;
    static final double advance = -0.1;
    Matrix orientation = new Matrix();
    Matrix gamma = new Matrix();
    Matrix delta = new Matrix();
    TwoDPoint velocity = new TwoDPoint(0, 0);
    Image image;
    Graphics buffer;
    Graphics screen;

    Figure(String title) {
        super(title);
        this.setSize(new Dimension(500, 500));
        this.setBackground(Color.black);
        this.setVisible(true);
        this.screen = this.getGraphics();
        this.screen.translate(250, 250);
        this.image = this.createImage(500, 500);
        this.buffer = this.image.getGraphics();
        this.buffer.translate(250, 250);
    }

    ThreeDPoint viewerPosition() {
        return this.orientation.mult(this.baseViewerPosition);
    }

    ThreeDPoint lightSource() {
        return this.orientation.mult(baseLightSource);
    }

    void render(Square s) {
        ThreeDPoint p = this.viewerPosition();
        float intensity = this.fill ? (float)(this.lightSource().cos(s.normal) + 1.0) / 2.0f : 1.0f;
        float r = intensity * (float)s.color.getRed() / 256.0f;
        float g = intensity * (float)s.color.getGreen() / 256.0f;
        float b = intensity * (float)s.color.getBlue() / 256.0f;
        this.buffer.setColor(new Color(r, g, b));
        if (this.fill) {
            this.buffer.fillPolygon(s.project(this.orientation, this.baseViewerPosition));
        } else {
            this.buffer.drawPolygon(s.project(this.orientation, this.baseViewerPosition));
        }
    }

    void animate(Thread thread) {
        while (true) {
            double theta = Math.atan2(this.velocity.y, this.velocity.z);
            double r = this.velocity.y * this.velocity.y + this.velocity.z * this.velocity.z;
            this.gamma.y.y = Math.cos(theta);
            this.gamma.y.z = -Math.sin(theta);
            this.gamma.z.y = Math.sin(theta);
            this.gamma.z.z = Math.cos(theta);
            this.delta.x.x = Math.cos(r);
            this.delta.x.y = -Math.sin(r);
            this.delta.y.x = Math.sin(r);
            this.delta.y.y = Math.cos(r);
            this.orientation = this.orientation.mult(this.gamma.mult(this.delta.mult(this.gamma.transpose())));
            this.baseViewerPosition.x = this.viewerDistance = Math.max(Double.NEGATIVE_INFINITY, this.viewerDistance + this.distanceVelocity);
            this.buffer.clearRect(-250, -250, 500, 500);
            this.cubes.render(this, this.viewerPosition());
            this.screen.drawImage(this.image, -250, -250, this);
            thread.yield();
        }
    }
}

