/** An instance maintains a time of day */
public class Time { 
    private int hr;  // hour of the day, in 0..23
    private int min; // minute of the hour, in 0..59

    /** Constructor: an instance with 0 hours and 0 minutes. */
    public Time() {
    }

    /** Constructor: an instance with h hours and m minutes.
     * Precondition: h in 0..23, m in 0..59 */
    public Time(int h, int m) {
        assert 0 <= h  &&  h <= 23  &&  0 <= m  && m <= 59;
        hr= h;
        min= m;
    }
    
    /** Constructor: an instance with m minutes.
     * Precondition: m in 0..24*60-1 */
    public Time(int m) {
        this(m/60, m%60); // this call on other constructor replaces 3 lines below
        //assert 0 <= m  &&  m < 24*60;
        // hr= m / 60;
        // min= m % 60;
    }

    /** Return the hour of the day */
    public int getHour() {
        return hr;
    }

    /** Return the minute of the hour */
    public int getMin() {
        return min;
    }

    /** Return a representation of this time, e.g. 09:05 */
    public String toString() {
        return prepend(hr) + ":" + prepend(min);
    }

    /** Return k as a string, prepended with
     * 0 if necessary so that it is two digits*/
    private String prepend(int k) {
        if (("" + k).length() == 1) {
            return "0" + k;
        }
        return "" + k;
    }

}
