import static org.junit.Assert.*;

import org.junit.Test;


public class TimeTester {

    @Test
    public void testConstructor1() {
        Time t1= new Time(6, 31);
        assertEquals(6, t1.getHour());
        assertEquals(31, t1.getMin());
    }
    
    @Test
    public void testSetters() {
        Time t1= new Time(6, 31);
        t1.setHour(23);
        assertEquals(23, t1.getHour());
        t1.setMinute(41);
        assertEquals(41, t1.getMin());
    }
    
    
    @Test
    public void testToString() {
        // note: testing Time is done to make sure that
        // prepend is appropriately tested with non-negative values
        Time t1= new Time(0, 1);
        assertEquals("00:01", t1.toString());
        t1.setHour(9);
        assertEquals("09:01", t1.toString());
        t1.setHour(10);
        assertEquals("10:01", t1.toString());
        t1.setMinute(59);
        assertEquals("10:59", t1.toString());
    }

}
