/** An instance maintains a time of day */
public class Time {

    private int hr;    //hour of the day, in 0..23
    private int min;   // minute of the hour, in 0..59

    /** Constructor: an instance with h hours and m minutes.
        Precondition: h in 0..23 and m in 0..59.   */
    public Time(int h, int m) {
        hr= h;
        min= m;
    }

    /** Constructor: an instance with m minutes.
        Precondition: m in 0..60*23+59.   */
    public Time(int m) {
        // fill in
    }


    /** Return hour of the day */
    public int getHour() {
        return hr;
    }

    /** Return minute of the hour */
    public int getMin() {
        return min;
    }

    /** Change the hour of the day to h.
        Precondition: h in 0..23 */
    public void setHour(int h) {
        hr= h;
    }

    /** Change the minute of the hour to m.
    Precondition: m in 0..59 */
    public void setMinute(int m) {
        min= m;
    }

    /** Return a represention of this time, e.g. 09:05*/
    public String toString() {
        return prepend(hr)  +  ":"  +  prepend(min);
    }

    /** Return i with preceding 0, if         necessary, to make two chars. */
    private String prepend(int i) {
        if (i > 9 || i < 0) return "" + i;
        return "0" + i;
    }

}
