import java.awt.*;
import java.awt.geom.*;
import javax.swing.*;
import java.util.*;

public class HashTableGraph extends JPanel {
    long[] data;
    final int PAD = 20;
    
    public HashTableGraph(long[] points) {
    	data = points;
    }
 
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                            RenderingHints.VALUE_ANTIALIAS_ON);
        int w = getWidth();
        int h = getHeight();

        g2.draw(new Line2D.Double(PAD, PAD, PAD, h-PAD));

        g2.draw(new Line2D.Double(PAD, h-PAD, w-PAD, h-PAD));
        double xInc = (double)(w - 2*PAD)/(data.length-1);
        double scale = (double)(h - 2*PAD)/getMax();

        g2.setPaint(Color.red);
        for(int i = 0; i < data.length; i++) {
            double x = PAD + i*xInc;
            double y = h - PAD - scale*data[i];
            g2.fill(new Ellipse2D.Double(x-2, y-2, 4, 4));
        }
    }
 
    private long getMax() {
        long max = -Long.MAX_VALUE;
        for(int i = 0; i < data.length; i++) {
            if(data[i] > max)
                max = data[i];
        }
        return max;
    }
 
    public static void main(String[] args) {
        HashMap<String,Integer> hTable = new HashMap<String,Integer>();
        int numPoints = 1000;
        long[] durations = new long[numPoints];
        for (int i=0; i<numPoints; i++) {
        	long start = System.nanoTime();
        	hTable.put(""+i,i);
        	long end = System.nanoTime();
        	durations[i] = end - start;
        	System.out.println(durations[i]);
        }

        JFrame w = new JFrame("Hash Table");
        w.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        w.add(new HashTableGraph(durations));
        w.setSize(800,600);
        w.setLocation(200,120);
        w.setVisible(true);        
    }
}
