public class Triple<T1 extends Comparable<T1>, T2 extends Comparable<T2>, T3 extends Comparable<T3>> implements Comparable<Triple<T1,T2,T3>> {
	T1 c1;
	T2 c2;
	T3 c3;
	
	public Triple(T1 c1, T2 c2, T3 c3) {
		this.c1 = c1;
		this.c2 = c2;
		this.c3 = c3;
	}
	
	// lexicographic
	public int compareTo(Triple<T1,T2,T3> obj) {
		int r1 = c1.compareTo(obj.c1);
		if (r1 != 0) return r1;
		int r2 = c2.compareTo(obj.c2);
		if (r2 != 0) return r2;
		int r3 = c3.compareTo(obj.c3);
		if (r3 != 0) return r3;
		return 0;
	}
	
	public String toString() {
		return "(" + c1.toString() + "," + c2.toString() + "," + c3.toString() + ")";
	}
	
	public static void main(String[] args) {
		Triple<Integer,String,Float> p = new Triple<Integer,String,Float>(new Integer(1),"hi",new Float(85.5));
		System.out.println(p);
	}
	
}
