import java.util.List;
import java.util.ArrayList;

public class Sequence<T extends Comparable<T>> implements Comparable<Sequence<T>> {
	T[] seq;
	
	public Sequence(T[] s) {
		seq = s;
	}
	
	// Lexicographic ordering.
	public int compareTo(Sequence<T> obj) {
		int n1 = seq.length;
		int n2 = obj.seq.length;
		int n = Math.min(n1,n2);
		for (int i=0; i<n; i++) {
			int c = seq[i].compareTo(obj.seq[i]);
			if (c != 0) return c;
		}
		return n1 - n2;
	}
	
	public String toString() {
		return java.util.Arrays.toString(seq);
	}
	
	public static void main(String[] args) {
		Integer[][] intArrays = new Integer[][] {
			new Integer[] {1,2,3},
			new Integer[] {1},
			new Integer[] {1, 3},
			new Integer[] {2},
			new Integer[] {},
			new Integer[] {1,2},
			new Integer[] {1,2,3,4},
			new Integer[] {1,2,4,3}
		};
		
		List<Sequence<Integer>> intSeqs = new ArrayList<Sequence<Integer>>(intArrays.length);
		for (int i=0; i<intArrays.length; i++)
			intSeqs.add(new Sequence<Integer>(intArrays[i]));

		System.out.println(intSeqs);
		java.util.Collections.sort(intSeqs);
		System.out.println(intSeqs);
	}
}