package sortGUI;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;

@SuppressWarnings("serial")
public class SortComparisons extends JFrame implements Runnable, ActionListener {

	private boolean[] algorithmsChosen; // keep track of which algorithms were chosen to run
	private final int PANEL_WIDTH = 660;
	private final int PANEL_HEIGHT = 500;

	public SortComparisons() {
		algorithmsChosen = new boolean[SortItem.SORTS.length];
		setAlgorithmsChosenFalse();
	}// end constructor

	private void createAndShowGUI() {
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setTitle("Sorting Algorithm Comparisons");
		setSize(PANEL_WIDTH, PANEL_HEIGHT);
		setLayout(new BorderLayout());

		// panel that contains all the sorts
		JPanel sortsPanel = new JPanel();
		int numCols = 3;
		int numRows = SortItem.SORTS.length / numCols
				+ ((SortItem.SORTS.length % numCols != 0) ? 1 : 0);
		sortsPanel.setLayout(new GridLayout(numRows, numCols));

		// crate and add panels for all the sort items
		for (int i = 0; i < SortItem.SORTS.length; i++) {
			JPanel panel = new JPanel(new BorderLayout());
			panel.setSize(new Dimension(PANEL_WIDTH, PANEL_HEIGHT));
			EmptyBorder temp = new EmptyBorder(10, 10, 10, 10);
			panel.setBorder(BorderFactory.createTitledBorder(temp,
					SortItem.SORTS[i], TitledBorder.CENTER, TitledBorder.TOP));
			panel.add(new SortItem(SortItem.SORTS[i]), BorderLayout.CENTER);
			sortsPanel.add(panel);
		}// end for

		//add title 
		String titleString = "<html> <table><tr><td width=265>&nbsp</td><td>Sorting Algorithms!</td></tr></table></html>";
		JLabel title = new JLabel(titleString);
		add(title, BorderLayout.NORTH);
		add(sortsPanel, BorderLayout.CENTER);

		//add options for algorithms to run and data type
		JMenuItem sortOptions = new JMenuItem("Algorithms to Run");
		sortOptions.addActionListener(this);
		JMenuItem dataType = new JMenuItem("Data Type");
		dataType.addActionListener(this);

		JMenu optionsMenu = new JMenu("Options");
		optionsMenu.add(sortOptions);
		optionsMenu.add(dataType);

		JMenuBar bar = new JMenuBar();
		bar.add(optionsMenu);
		setJMenuBar(bar);

		setResizable(false);
		setLocationRelativeTo(null);
		setVisible(true);
	}// end createAndShowGUI

	public void run() {
		createAndShowGUI();
	}// end run;

	private boolean anySortRunning() {
		for (SortItem si : SortItem.getSortItems())
			if (si.isRunning())
				return true;
		return false;
	}// end anySortRunning

	private void setAlgorithmsChosenFalse() {
		for (int i = 0; i < algorithmsChosen.length; i++)
			algorithmsChosen[i] = false;
	}// end setAlgorithmsChosenFalse

	public void actionPerformed(ActionEvent ae) {

		//popup menu to choose algorithms
		if (ae.getActionCommand().equals("Algorithms to Run")) {
			setAlgorithmsChosenFalse();
			new Thread(new ChooseSortAlgorithms(this, algorithmsChosen)).start();
		}// end if
		
		//start algorithms chosen and restart them if necessary
		else if (ae.getActionCommand().equals("Submit")) {
			for (int i = 0; i < SortItem.getSortItems().size(); i++)
				if (algorithmsChosen[i])
					SortItem.getSortItems().get(i).sort();
		}// end else if
		
		//allow user to change data type if a sort is not running
		else if (!anySortRunning()) {
			//popup menu to choose data type
			if (ae.getActionCommand().equals("Data Type"))
				new Thread(new ChooseDataType(this)).start();
			
			//change the data type to sort
			else{
				for (int i = 0; i < SortItem.DATA_TYPES.length; i++)
					if (ae.getActionCommand().equals(SortItem.DATA_TYPES[i]))
						SortItem.setArrayType(SortItem.DATA_TYPES[i]);
			}// end else
		}// end else if
		
		//warn user they cannot switch the data type while a sort is running
		else{
			JFrame warning = new JFrame();
			String labelText = "You cannot switch the data type while a sort is running";
			warning.setSize(new Dimension((int) (labelText.length() * 6.1),	100));
			warning.add(new JLabel(labelText));
			warning.setLocationRelativeTo(null);
			warning.setVisible(true);
		}// end else
	}// end actionPerformed
}// end SortComparisons