/*Class to represent a quick sort*/
package sortGUI;

public class QuickSortAlgorithm extends SortAlgorithm {
	
	public QuickSortAlgorithm(int[] a, SortItem parent){
		super(a, parent);
	}//end constructor
	
	private void quickSort(int[] a, int lo0, int hi0)  {
	
		int lo = lo0;
		int hi = hi0;
		
		pause(lo, hi);
		
		if (lo >= hi) 
			return;
	
		int mid = a[(lo + hi) / 2];
		
		//throw values less than the pivot to the right of the pivot
		//throw values greater than the pivot to the right of the pivot
		while (lo < hi) {
			
			while (lo<hi && a[lo] < mid){
				lo++;
				pause(lo, hi);
			}//end while
			
			while (lo<hi && a[hi] > mid){ 
				hi--;
				pause(lo, hi);
			}//end while
			
			if (lo < hi) {
				int T = a[lo];
				a[lo] = a[hi];
				a[hi] = T;
				lo++;
				hi--;
				pause(lo, hi);
			}//end if
		}//end while
		
		//if the indices ran past each other, swap them
		if (hi < lo) {
			int T = hi;
			hi = lo;
			lo = T;
			pause(lo, hi);
		}//end if
		
		//sort each half
		quickSort(a, lo0, lo);
		quickSort(a, lo == lo0 ? lo+1 : lo, hi0);
	}//end quickSort

	public void sort() {
		quickSort(a, 0, a.length-1);
	}//end sort
}//end QuickSort
