/*Class that represents Heapsort*/
package sortGUI;

public class HeapSortAlgorithm extends SortAlgorithm {

	public HeapSortAlgorithm(int[] a, SortItem parent){
		super(a, parent);
	}//end constructor
	
	public void sort() {
		
		//heapify the heap
		for(int i=a.length/2; i>=0; i--){
			percDown(a, i, a.length);
			pause(i, a.length);
		}//end for
		
		//move max values to the bottom and reheapify
		for(int i=a.length-1; i>0; i--){
			swap(a, 0, i);
			percDown(a, 0, i);
			pause(0, i);
		}//end for
	}//end sort
	
	//gets left child index
	private static int leftChild(int i){
		return 2*i+1;
	}//end leftChild

	//heapifies the heap - if a value is smaller than either of its two children, 
	//promote the child 
	private void percDown(int[] a, int i, int n){
		int child=0;
		int temp;
		for(temp=a[i]; leftChild(i)<n; i=child){
			child=leftChild(i);
			pause(i);
			
			//determine which child is bigger
			if(child!=n-1 && a[child]<a[child+1]){
				child++;
				pause(child);
			}//end if
			
			//if temp is less than either of the two children, promote the child
			if(temp<a[child]){
				a[i]=a[child];
				pause(i, child);
			}//end if
			else
				break;
		}//end for
	
		a[i]=temp;
	}//end percDown
	
	//swaps to values in the array
	private void swap(int[] a, int i, int j){
		pause(i, j);
		int temp=a[j];
		a[j]=a[i];
		a[i]=temp;
	}//end swap
}//end HeapSortAlgorithm