/*Class that allows user to choose which sort algorithms to run*/
package sortGUI;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

@SuppressWarnings("serial")
public class ChooseSortAlgorithms extends JDialog implements ActionListener, Runnable{
	
	private boolean[] chosen;			//sortAlgorithms chosen
	private SortComparisons parent;		//main GUI parent window
	private JCheckBox[] checkBoxes;		//checkboxes of algorithms to run
	
	public ChooseSortAlgorithms(SortComparisons owner, boolean[] chosen){
		super(owner, true);
		this.parent=owner;
		this.chosen=chosen;
		checkBoxes=new JCheckBox[6];
	}//end constructor
	
	public void createAndShowGUI(){
		int numRows=SortItem.SORTS.length/2+SortItem.SORTS.length%2;
		
		setSize(new Dimension(300, (numRows+1)*50));
		setLayout(new BorderLayout());
		
		//panel of algorithm choices
		JPanel choicePanel=new JPanel();
		choicePanel.setLayout(new GridLayout(numRows, 2));
		setTitle("Choose Your Sorting Algorithms");
		
		for(int i=0; i<SortItem.SORTS.length; i++){
			checkBoxes[i]=new JCheckBox(SortItem.SORTS[i]);
			choicePanel.add(checkBoxes[i]);
			checkBoxes[i].addActionListener(this);
		}//end for	
		
		add(choicePanel, BorderLayout.CENTER);
		
		//add submit button - squeeze on both sides with empty spaces
		JPanel buttonPanel=new JPanel();
		buttonPanel.setLayout(new BorderLayout());
		String emptySpace="<html><table><tr><td width="+getSize().width/4+">&nbsp</td><td>&nbsp</td></tr></table></html>";
		buttonPanel.add(new JLabel(emptySpace), BorderLayout.WEST);
		buttonPanel.add(new JLabel(emptySpace), BorderLayout.EAST);
		JButton submit=new JButton("Submit");
		
		buttonPanel.add(submit, BorderLayout.CENTER);
		submit.addActionListener(parent);
		submit.addActionListener(this);
		add(buttonPanel, BorderLayout.SOUTH);
		
		setLocationRelativeTo(null);
		setResizable(false);
		setVisible(true);
	}//end createAndShowGUI

	//if submitted, close the window
	//otherwise, mark the selected algorithm as chosen
	public void actionPerformed(ActionEvent ae) {
		if(ae.getActionCommand().equals("Submit"))
			dispose();
		else{
			int i=0;
			boolean found=false;
			
			//find the algorithm that was selected and mark as chosen
			while(i<checkBoxes.length && !found){
				if(ae.getSource()==checkBoxes[i]){
					chosen[i]=checkBoxes[i].isSelected();
					found=true;
				}//end if
				i++;
			}//end while
		}//end else
	}//end actionPerformed

	public void run() {
		createAndShowGUI();
	}//end run
}//end ChooseSortAlgorithms
