/*Class to represent a BucketSort*/
package sortGUI;

public class BucketSortAlgorithm extends SortAlgorithm {

	public BucketSortAlgorithm(int[] a, SortItem parent){
		super(a, parent);
	}//end constructor
	
	public void sort() {
		int[] freq=new int[max(a)+1];
		
		//scan through array and find frequencies of each item
		for(int i=0; i<a.length; i++){
			pause(i, a.length-1);
			freq[a[i]]++;
		}//end for
		
		int j=0;
		
		//put items in array in sorted order
		for(int i=0; i<freq.length; i++){
			while(freq[i]>0){
				a[j++]=i;
				freq[i]--;
				pause(j, a.length-1);
			}//end while
		}//end for
	}//end sort
	
	//finds the maximum value of the array
	private int max(int[] a){
		int toRet=Integer.MIN_VALUE;
		
		for(int i: a)
			if(i>toRet)
				toRet=i;
		return toRet;
	}//end max
}//end BucketSortAlgorithm
