import java.util.Random;
import java.util.Arrays;

public class MergeSort {
  
  // Iterative merge sort.
  public static void mergeSortIter(int[] a) {
    int n = a.length;
    int tmp[] = new int[n];
    int prevBlock = 1;
    int block = 2;
    while (block < 2*n) {
      //System.out.println("block = " + block);
      //System.out.println("a: " + Arrays.toString(a));
      
      int i=0;
      for (; i<n-block; i+=block) {
        merge(a,i,i+prevBlock-1,a,i+prevBlock,i+block-1,tmp,i);
      }

      // last block might extend beyong array
      int to1 = i+prevBlock-1;
      int from2 = i+prevBlock;
      int to2 = i+block-1;
      if (to1 >= n) to1 = n-1;
      if (from2 >= n) { // no second part to merge
        from2 = 0;
        to2 = -1;
      }
      else { // from2 < n
        if (to2 >= n) to2 = n-1;
      }
      merge(a,i,to1,a,from2,to2,tmp,i);
      
      //System.out.println("tmp: " + Arrays.toString(tmp));
      
	  // copy tmp to a
      for (int j=0; j<n; j++) a[j] = tmp[j];
	  
      prevBlock = block;
      block *= 2;
    }
  }

  // Recursive merge sort  
  public static void mergeSort(int[] a) {
    mergeSort(a,0,a.length-1);  
  }
  
  // Merge sorted array segments.
  private static void merge(int[] part1, int from1, int to1,
                            int[] part2, int from2, int to2,
                            int[] output, int outFrom) {
    int i = from1;
    int j = from2;
    int k = outFrom;
    while ( (i <= to1) || (j <= to2) ) {
      if (i <= to1) {
        if (j <= to2) {
          if (part1[i] <= part2[j]) {
            output[k++] = part1[i++];
          }
          else {
            output[k++] = part2[j++];
          }
        }
        else {
          output[k++] = part1[i++];
        }
      }
      else { // j <= to
        output[k++] = part2[j++];
      }
    }
  }
  
  // Recursive merge sort.
  private static void mergeSort(int[] a, int from, int to) {
    if (from == to) return;
    
    int middle = (from + to) / 2;
    mergeSort(a,from,middle);
    mergeSort(a,middle+1,to);
    
    // merge
    int[] tmp = new int[to - from + 1];
    merge(a,from,middle,a,middle+1,to,tmp,0);
    for (int c=0; c<tmp.length; c++) a[from+c] = tmp[c];
  }
  
  public static void main(String[] args) {
    Random g = new Random();
    int[] a = new int[23];
    for (int i=0; i<a.length; i++) a[i] = Math.abs(g.nextInt()) % (100);
    System.out.println(Arrays.toString(a));
    
    final long startTime = System.nanoTime();
    final long endTime;
    try {
      mergeSortIter(a);
    } finally {
      endTime = System.nanoTime();
    }
    final long duration = endTime - startTime;
    System.out.println("duration = " + (duration/1000000));
    
    System.out.println(Arrays.toString(a));
  }
}
