public class PerfectSquares {
	
	// Decides if an integer n >= 0 is a perfect square.
	// running time: O(n) =>
	// exponential, because size of input is log(n).
	public static boolean isPerfectSquare1(int n) {
		for (int i=n; i >= 0; i--)
			if (i*i == n) return true;
		return false;
	}
	
	// Decides if an integer n >= 0 is a perfect square.
	// running time: O(sqrt(n)) => exponential (Exercise: prove it.)
	public static boolean isPerfectSquare2(int n) {
		int i = 0;
		while (true) {
			int sq = i*i;
			if (sq == n)
				return true;
			else if (sq > n)
				break;
			i++;
		}
		return false;
	}
	
	// Decides if an integer n >=0 is a perfect square.
	// running time: O(log n) => linear
	public static boolean isPerfectSquare3(int n) {
		return isPerfectSquare3Aux(n,0,n);
	}
	
	// Decides if an integer n >=0 is a perfect square with sqrt(n) in [from,to].
	private static boolean isPerfectSquare3Aux(int n, int from, int to) {
		if (from > to)
			return false;
			
		int middle = (from + to) / 2;
		int sq = middle * middle;
		
		if (sq == n)
			return true;
		else if (sq > n)
			return isPerfectSquare3Aux(n,from,middle-1);
		else // sq < n
			return isPerfectSquare3Aux(n,middle+1,to);
	}
	
	public static void main(String[] args) {
		for (int n=0; n <= 2000; n++) {
			boolean b1 = isPerfectSquare1(n);
			boolean b2 = isPerfectSquare2(n);
			boolean b3 = isPerfectSquare3(n);
			System.out.println("isSquare(" + n + "): " + b1 + ", " + b2 + ", " + b3);
		}
	}
	
}
