public class Stack<T> {
	
	ListNode<T> list;
	
	public Stack() {
		
	}
	
	public void push(T d) {
		if (list == null)
			list = new ListNode<T>(d);
		else
			list = list.prepend(d);
	}
	
	public boolean hasMore() {
		return list != null;
	}
	
	public T peek() {
		if (!hasMore()) return null;
		return list.getDatum();
	}
	
	public T pop() {
		if (!hasMore()) return null;
		T d = list.getDatum();
		list = list.getTail();
		return d;
	}
	
	public static void main(String[] args) {
		Stack<Integer> stack = new Stack<Integer>();
		stack.push(3);
		stack.push(5);
		System.out.println(stack.pop());
		System.out.println(stack.pop());
		System.out.println(stack.pop());
	}
	
}
