import static org.junit.Assert.assertEquals;

import org.junit.Before;
import org.junit.Test;

public class SongTests {
	Song example;
	double[] stats;
	
	@Before
	public void initSong(){
		int[] stationPlays = {1, 4, 3, 5, 2};
		example = new Song("My Song","My Artist",3,5);
		example.setStationPlays(stationPlays);
		stats = example.getStatistics();
	}
	
	@Test
	public void testStatisticsSize(){
		assertEquals("Check array size.",6,stats.length);
	}
	
	@Test
	public void testAverage(){
		assertEquals("Check average.",3,stats[0],0.00001);
	}
	
	@Test
	public void testTotalPlays(){
		assertEquals("Check total plays.",15,stats[1],0.00001);
	}
	
	@Test
	public void testMaxPlaysStation(){
		assertEquals("Check station with most plays.",3,stats[2],0.00001);
	}
	
	@Test
	public void testMaxPlays(){
		assertEquals("Check most plays in one station.",5,stats[3],0.00001);
	}
	
	@Test
	public void testMinPlaysStation(){
		assertEquals("Check station with least plays.",0,stats[4],0.00001);
	}
	
	@Test
	public void testMinPlays(){
		assertEquals("Check least plays in one station.",1,stats[5],0.00001);
	}
	
	//checks casted ints to double when dividing for the average
	@Test
	public void testCastedToDouble(){
		int[] stationPlays = {1, 4, 3, 2};
		Song doubleexample = new Song("My Song","My Artist",3,4);
		doubleexample.setStationPlays(stationPlays);
		double[] doublestats = doubleexample.getStatistics();
		assertEquals("Check average.",2.5,doublestats[0],0.00001);
	}
}
