
public class Song{
	private String name;
	private String artist;
	private int ID;
	private int[] stationPlays; 
	

	/**
	 * @return The name of this song.
	 */
	public String getName() {
		return name;
	}
	
	/**
	 * @param name A name for this song.
	 */
	public void setName(String name) {
		this.name = name;
	}
	/**
	 * @return The artist that poured their heart and soul 
	 * into making this work of art. Don't pirate music! 
	 * You wouldn't download a bear.
	 */
	public String getArtist() {
		return artist;
	}
	/**
	 * @param artist An artist for this song.
	 */
	public void setArtist(String artist) {
		this.artist = artist;
	}
	/**
	 * @return Returns the Song Id. 
	 */
	public int getID() {
		return ID;
	}
	/**
	 * @param iD Set a Song Id
	 */
	public void setID(int iD) {
		ID = iD;
	}

	/**
	 * @return  An array the length of the number of radio stations. 
	 * stationPlays[i] should be the number of times this song is played on 
	 * the station with station id equal to i. 
	 */
	public int[] getStationPlays() {
		return stationPlays;
	}
	
	public void setStationPlays(int[] stationPlays){
		this.stationPlays = stationPlays;
	}

	/** Constructor. 
	 * @param name Name of this song
	 * @param artist Artist of this song
	 * @param ID Id of this song
	 * @param numStations The total number of radio stations.
	 */
	public Song(String name, String artist, int ID, int numStations) {
		this.name = name;
		this.artist = artist;
		this.ID = ID;
		stationPlays = new int[numStations];
	}
	
	/**Increments the count in our stationPlays array. 
	 * 
	 * @param stationId 
	 */
	public void addPlay(int stationId){
		stationPlays[stationId] = stationPlays[stationId] + 1;
	}
	
	/** Calculates basic statistics about this current song and returns it in an array of integers. 
	 * The order of the calculations should be: 
	 * <ol>
	 *  <li>Average number of plays on each station that carries it, 0 if song is never played</li>
	 *  <li>Total number of plays across all stations</li>
	 *  <li>Station that plays this specific song most often, 
	 *  -1 if the song is played the same number of times across all stations</li>
	 *  <li>Maximum number of plays on one station</li>
	 *  <li>Station that plays this specific song the least
	 *  -1 if the song is played the same number of times across all stations</li>
	 *  <li>Minimum number of plays on any one station</li>
	 * <ol>
	 * If the song is never played, the average in (0) should be set to 0. 
	 * For all calculations except for the average, we can count stations that do not carry this song.
	 * That is the maximum and minimum number of plays can be 0.
	 * If multiple stations play this song the same number of times, use the station with the lowest station id for (2) and (4). 
	 * If no stations play this song, (2) and (4) should be set to -1 since our station ids are zero-based. 
	 * @return An array of basic song statistics 
	 */
	public double[] getStatistics(){
		//Not sure if this is what you want 
		//but this average only takes into account stations that have at least one play
		double totalPlays = 0; //across all stations
		double tallyStations = 0; //count only stations that play this SongTester as part of the denominator,

		double maxPlays = Double.MIN_VALUE;
		double maxPlayedStation = -1;

		double minPlays = Double.MAX_VALUE;
		double minPlayedStation = -1;

		for(int i = 0; i < stationPlays.length; i++){
			if(stationPlays[i] > 0){
				totalPlays += stationPlays[i];
				tallyStations++;
			}
			if (stationPlays[i]> maxPlays){
				maxPlayedStation = i;
				maxPlays = stationPlays[i];
			}
			if(stationPlays[i]< minPlays){
				minPlayedStation = i;
				minPlays = stationPlays[i];
			}
		}
		double[] stats = new double[6];
		stats[0] = tallyStations > 0 ? (totalPlays / tallyStations) : 0;
		stats[1] = totalPlays;
		stats[2] = maxPlayedStation;
		stats[3] = maxPlays== Double.MIN_VALUE ? 0 : maxPlays;
		stats[4] = minPlayedStation;
		stats[5] = minPlays == Double.MAX_VALUE ? 0 : minPlays;
		//Added this part to satisfy javadoc comments.
		if (stats[3] == stats[5]){
			stats[2] = -1;
			stats[4] = -1;
		}
		return stats;
	}
	
	@Override
	public String toString() {
		return ID + ". " + artist + " - " + name;
	}
	
}
