public class Queue<T> {
	
	CListNode<T> cList;
	
	public Queue() {
		
	}
	
	public void enqueue(T d) {
		if (cList == null)
			cList = new CListNode<T>(d);
		else
			cList = cList.append(d);
	}
	
	public boolean hasMore() {
		return cList != null;
	}
	
	public T peek() {
		if (!hasMore()) return null;
		return cList.getNext().getDatum();
	}
	
	public T dequeue() {
		if (!hasMore()) return null;
		CListNode<T> first = cList.getNext();
		T d = first.getDatum();
		if (first == cList)
			cList = null;
		else
			cList.setNext(first.getNext());
		return d;
	}
	
	public static void main(String[] args) {
		Queue<Integer> queue = new Queue<Integer>();
		queue.enqueue(3);
		queue.enqueue(5);
		System.out.println(queue.dequeue());
		System.out.println(queue.dequeue());
		System.out.println(queue.dequeue());
	}

}
