import static org.junit.Assert.*;
import org.junit.Test;

public class ListNodeTest {

	@Test
	public void testListNodeTListNodeOfT() {
		ListNode<Integer> lastNode = new ListNode<Integer>(2);
		ListNode<Integer> firstNode = new ListNode<Integer>(1,lastNode);
		assertEquals(new Integer(1),firstNode.getDatum());
		assertEquals(lastNode,firstNode.getTail());
	}

	@Test
	public void testListNodeT() {
		ListNode<Integer> list = new ListNode<Integer>(5);
		assertEquals(new Integer(5),list.getDatum());
		assertEquals(null,list.getTail());
	}

	@Test
	public void testCreateList() {
		int n = 5;
		Integer[] ints = new Integer[n];
		for (int i=0; i<n; i++) ints[i] = i;
		ListNode<Integer> list = ListNode.createList(ints);
		
		int counter = 0;
		ListNode<Integer> current = list;
		while (current != null) {
			assertEquals(new Integer(counter),current.getDatum());
			current = current.getTail();
			counter++;
		}
		assertEquals(counter,n);
	}

	@Test
	public void testPrepend() {
		ListNode<Integer> list = new ListNode<Integer>(2);
		list = list.prepend(1);
		assertEquals(new Integer(1),list.getDatum());
		assertTrue(list.getTail() != null);
		ListNode<Integer> tail = list.getTail();
		assertEquals(new Integer(2),tail.getDatum());
		assertTrue(tail.getTail() == null);
	}

	@Test
	public void testAppend() {
		ListNode<Integer> list = new ListNode<Integer>(1);
		list.append(2);
		assertEquals(new Integer(1),list.getDatum());
		assertTrue(list.getTail() != null);
		ListNode<Integer> tail = list.getTail();
		assertEquals(new Integer(2),tail.getDatum());
		assertTrue(tail.getTail() == null);
	}

	@Test
	public void testGetSize() {
		int n = 5;
		Integer[] ints = new Integer[n];
		ListNode<Integer> list = ListNode.createList(ints);
		assertEquals(n,list.getSize());
	}

	@Test
	public void testToString() {
		int n = 5;
		Integer[] ints = new Integer[n];
		for (int i=0; i<n; i++) ints[i] = i;
		ListNode<Integer> list = ListNode.createList(ints);
		assertEquals("[0,1,2,3,4]",list.toString());
	}

}
