public class ListNode<T> {
	T datum;
	ListNode<T> next;
	
	public ListNode(T d, ListNode<T> n) {
		datum = d;
		next = n;
	}

	public ListNode(T d) {
		this(d,null);
	}
	
	public T getDatum() {
		return datum;
	}

	public ListNode<T> getTail() {
		return next;
	}
	
	public static <T> ListNode<T> createList(T[] data) {
		ListNode<T> list = null;
		
		for (int index = data.length - 1; index >= 0; index--) {
			list = new ListNode<T>(data[index],list);
		}
		
		return list;
	}
	
	public ListNode<T> prepend(T d) {
		return new ListNode<T>(d,this);
	}
	
	public void append(T d) {
		ListNode<T> previous = this;
		ListNode<T> current = this.next;
		while (current != null) {
			previous = current;
			current = current.next;
		}
		// current == null
		// previous is the last node
		previous.next = new ListNode<T>(d);
	}
	
	public int getSize() {
		int size = 0;
		ListNode<T> current = this;
		while (current != null) {
			size++;
			current = current.next;
		}
		return size;
	}
	
	public String toString() {
		String str = datum.toString();
		ListNode<T> current = next;
		while (current != null) {
			str += "," + current.datum.toString();
			current = current.next;
		}
		return "[" + str + "]";
	}
	
	public static void main(String[] args) {
		Integer[] ints = new Integer[] { 3, 5, 10, -8 };
		ListNode<Integer> list = createList(ints);
		System.out.println(list);
		list = list.prepend(-1);
		System.out.println(list);
		list.append(100);
		System.out.println(list);
		System.out.println("size = " + list.getSize());
	}
}
