import static org.junit.Assert.*;
import org.junit.Test;

public class CListNodeTest {

	@Test
	public void testCreateList() {
		int n = 5;
		Integer[] ints = new Integer[n];
		for (int i=0; i<n; i++) ints[i] = i;
		CListNode<Integer> last = CListNode.createList(ints);
		
		CListNode<Integer> first = last.getNext();
		int counter = 0;
		CListNode<Integer> current = first;
		assertEquals(new Integer(counter),current.getDatum());
		current = current.getNext();
		counter++;
		
		while (current != first) {
			assertEquals(new Integer(counter),current.getDatum());
			current = current.getNext();
			counter++;
		}
		assertEquals(counter,n);
	}

	@Test
	public void testPrepend() {
		CListNode<Integer> last = new CListNode<Integer>(2);
		last.prepend(1);
		
		CListNode<Integer> first = last.getNext();
		assertEquals(new Integer(1),first.getDatum());
		assertTrue(first.getNext() == last);
		assertEquals(new Integer(2),last.getDatum());
		assertTrue(last.getNext() == first);
	}

	@Test
	public void testAppend() {
		CListNode<Integer> first = new CListNode<Integer>(1);
		CListNode<Integer> last = first.append(2);
		
		assertEquals(new Integer(1),first.getDatum());
		assertTrue(first.getNext() == last);
		assertEquals(new Integer(2),last.getDatum());
		assertTrue(last.getNext() == first);
	}

	@Test
	public void testGetSize() {
		int n = 5;
		Integer[] ints = new Integer[n];
		CListNode<Integer> list = CListNode.createList(ints);
		assertEquals(n,list.getSize());
	}

	@Test
	public void testToString() {
		int n = 5;
		Integer[] ints = new Integer[n];
		for (int i=0; i<n; i++) ints[i] = i;
		CListNode<Integer> list = CListNode.createList(ints);
		assertEquals("[0,1,2,3,4]",list.toString());
	}

}
