// For a circular list, we are interested in the pointer to the last element.
public class CListNode<T> {
	T datum;
	CListNode<T> next;
	
	public CListNode(T d, CListNode<T> n) {
		datum = d;
		next = n;
	}
	
	public CListNode(T d) {
		datum = d;
		next = this;
	}
	
	public T getDatum() {
		return datum;
	}

	public CListNode<T> getNext() {
		return next;
	}
	
	public void setNext(CListNode<T> n) {
		next = n;
	}

	// this is the pointer to the last node of the list
	public void prepend(T d) {
		CListNode<T> first = this.next;
		CListNode<T> node = new CListNode<T>(d,first);
		this.next = node;
	}
	
	// this is the pointer to the last node of the list
	public CListNode<T> append(T d) {
		CListNode<T> first = this.next;
		CListNode<T> node = new CListNode<T>(d,first);
		this.next = node;
		return node;
	}
	
	// returns the pointer to the last element of the list
	public static <T> CListNode<T> createList(T[] data) {
		if (data.length == 0) return null;
		
		int len = data.length;
		CListNode<T> last = new CListNode<T>(data[len-1]);
		CListNode<T> first = last;
		for (int index = len-2; index >= 0; index--) {
			first = new CListNode<T>(data[index],first);
		}
		last.next = first;
		
		return last;
	}
	
	public int getSize() {
		int size = 0;
		CListNode<T> first = this.next;
		CListNode<T> current = first;
		do {
			size++;
			current = current.next;
		} while (current != first);
		
		return size;
	}
	
	public String toString() {
		CListNode<T> first = this.next;
		CListNode<T> current = first;
		String str = current.datum.toString();
		current = current.next;
		while (current != first) {
			str += "," + current.datum.toString();
			current = current.next;
		}
		return "[" + str + "]";
	}
	
	public static void main(String[] args) {
		Integer[] ints = new Integer[] { 1, 3, 5, 10, -8 };
		CListNode<Integer> list = createList(ints);
		System.out.println(list);
		list.prepend(-1);
		System.out.println(list);
		list = list.append(100);
		System.out.println(list);
		System.out.println("size = " + list.getSize());
	}
	
}
