public class StringRecursion {
	
	public static String reverse(String s) {
		if (s.length() == 0) return "";
		return reverse(s.substring(1)) + s.charAt(0);
	}
	
	public static boolean isPalindrome(String s) {
		if (s.length() < 2) return true;
		int len = s.length();
		return (s.charAt(0) == s.charAt(len-1)) && isPalindrome(s.substring(1,len-1));
	}

	public static int count(String s, char c) {
		if (s.length() == 0) return 0;
		return (s.charAt(0) == c ? 1 : 0) + count(s.substring(1),c);
	}
	
	public static void main(String[] args) {
		
		System.out.println(reverse(""));
		System.out.println(reverse("h"));
		System.out.println(reverse("hello"));
		
		String str = "abc";
		System.out.println("isPalindrome(" + str + ") = " + isPalindrome(str));
		str = "abbba";
		System.out.println("isPalindrome(" + str + ") = " + isPalindrome(str));
		
		str = "abcdeabcdea";
		char c = 'b';
		System.out.println("count(" + str + "," + c + ") = " + count(str,c));
	}
}
