public class Parsing {

	// Recognize strings of the language given by the grammar:
	// S ::= empty | (S)
	// Examples: () (()) ((()))
	static boolean balancedParenEasy(String s) {
		if (s.length() == 0) return true;
		if (s.length() == 1) return false;
		
		int len = s.length();
		return (s.charAt(0) == '(') && (s.charAt(len-1) == ')') && balancedParenEasy(s.substring(1,len-1));
	}
	
	// Recognize strings of the language given by the grammar:
	// S ::= empty | (S) | SS
	// Examples: () ()() (()()) ()(()) 
	static boolean balancedParenHard(String s) {
		int r = balancedParenHardAux(s,0);
		return r == s.length();
	}

	// returns the number of characters processed
	static int balancedParenHardAux(String s, int start) {
		if (s.length() == 0) return 0;

		int processed = 0;
		while ( start+processed < s.length() && s.charAt(start+processed) != ')') {
			if (s.charAt(start+processed) != '(') return -1;
			processed++;
			
			int processedRec = balancedParenHardAux(s,start+processed);
			if (processedRec < 0) return -1;
			processed += processedRec;
			
			if (start+processed >= s.length()) return -1;
			if (s.charAt(start+processed) != ')') return -1;
			processed++;
		}
		
		return processed;
	}
	
	// S ::= 0 | 1 | ... | 9 | (S+S) | (S*S) | -S
	static boolean isExpression(String s) {
		int r = isExpressionAux(s,0);
		return r == s.length();
	}

	static int isExpressionAux(String s, int start) {
		int processed = 0;
		
		if (start+processed >= s.length()) return -1;
		char c = s.charAt(start);
		
		if (Character.isDigit(c)) {
			processed++;
		}
		else if (c == '(') {
			processed++;
			
			int r = isExpressionAux(s,start+processed);
			if (r < 0) return -1;
			processed += r;
			
			if (start+processed >= s.length()) return -1;
			c = s.charAt(start+processed);
			if (c != '+' && c != '*') return -1;
			processed++;
			
			r = isExpressionAux(s,start+processed);
			if (r < 0) return -1;
			processed += r;
			
			if (start+processed >= s.length()) return -1;
			c = s.charAt(start+processed);
			if (c != ')') return -1;
			processed++;
		}
		else if (c == '-') {
			processed++;
			int r = isExpressionAux(s,start+processed);
			if (r < 0) return -1;
			processed += r;
		}
		else {
			return -1;
		}
		
		return processed;
	}
	
	public static void main(String[] args) {

		String str = "()";
		System.out.println("Balanced easy " + str + " : " + balancedParenEasy(str));
		str = "()()";
		System.out.println("Balanced easy " + str + " : " + balancedParenEasy(str));

		str = "())";
		System.out.println("Balanced hard " + str + " : " + balancedParenHard(str));
		str = "()";
		System.out.println("Balanced hard " + str + " : " + balancedParenHard(str));
		str = "()()";
		System.out.println("Balanced hard " + str + " : " + balancedParenHard(str));
		str = "(()())";
		System.out.println("Balanced hard " + str + " : " + balancedParenHard(str));
		str = "(()())()";
		System.out.println("Balanced hard " + str + " : " + balancedParenHard(str));
		str = "()()()((()";
		System.out.println("Balanced hard " + str + " : " + balancedParenHard(str));
		
		str = "5";
		System.out.println("Is expression " + str + " : " + isExpression(str));
		str = "5a";
		System.out.println("Is expression " + str + " : " + isExpression(str));
		str = "2+3";
		System.out.println("Is expression " + str + " : " + isExpression(str));
		str = "(2+3)";
		System.out.println("Is expression " + str + " : " + isExpression(str));
		str = "(8*9)";
		System.out.println("Is expression " + str + " : " + isExpression(str));
		str = "-10";
		System.out.println("Is expression " + str + " : " + isExpression(str));
		str = "-9";
		System.out.println("Is expression " + str + " : " + isExpression(str));
		str = "(-9)";
		System.out.println("Is expression " + str + " : " + isExpression(str));
		str = "(-6+-7)";
		System.out.println("Is expression " + str + " : " + isExpression(str));
		str = "-(-6+-7)";
		System.out.println("Is expression " + str + " : " + isExpression(str));
		str = "---3";
		System.out.println("Is expression " + str + " : " + isExpression(str));
	}
	
}
