

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class MathParser {

	public static void main(String[] args) {
		InputStreamReader inp = new InputStreamReader(System.in);
		BufferedReader br = new BufferedReader(inp);
		MathParser mp = new MathParser();
		System.out.println("Welcome to the simple Math Parser.\nPlease input your expression or write 'exit' to quit.");
		String line;
		try {
			double result = 0;
			while(true){
				line = br.readLine();
				if (line.equalsIgnoreCase("exit")) break;
				try {
					result = mp.parseS(line);
					System.out.println("Result = " + result);
				} catch (IncorrectSyntaxException e) {
					System.out.println("Incorrect syntax. Please try again.");
				} catch (ArithmeticException e){
					System.out.println("Division by zero error. Please try again.");
				}
			}
		} catch (IOException e) {
			e.printStackTrace();
		}
		System.out.println("Goodbye!");

	}

	/* Language Syntax 
	 * S = # | -# | E O E
	 * E = # | -# | (E O E)
	 * O = + | * | - | /
	 */
	private double parseS(String startExpression) throws IncorrectSyntaxException{
		int op = -1;
		int i = 0;
		startExpression = startExpression.trim();

		// S = (E O E) O E
		// Find where first parenthesis ends
		if (startExpression.charAt(0) == '('){
			int bracketCount = 1;
			for (i = 1; i < startExpression.length(); i++){
				if (startExpression.charAt(i) == '(') bracketCount++;
				if (startExpression.charAt(i) == ')') bracketCount--;
				if (bracketCount == 0) break;
			}
			if (bracketCount != 0) throw new IncorrectSyntaxException();
		}

		// Find first binary operator after first E
		for (; i < startExpression.length(); i++){
			switch(startExpression.charAt(i)){
			case '+':
			case '-':
			case '*':
			case '/':
				op = i;
				break;
			}
			if (op != -1) break;
		}

		// S = # | -#
		if (op == -1){
			try{
				return Double.valueOf(startExpression.trim());
			}catch(NumberFormatException e){
				throw new IncorrectSyntaxException();
			}
		}

		String left = startExpression.substring(0,op);
		String right = startExpression.substring(op+1);
		double leftEval = parseE(left);
		double rightEval = parseE(right);

		switch(startExpression.charAt(op)){
		case '+':
			return leftEval + rightEval;
		case '-':
			return leftEval - rightEval;
		case '*':
			return leftEval * rightEval;
		case '/':
			if (rightEval == 0)	throw new ArithmeticException();
			return leftEval / rightEval;
		default:
			throw new IncorrectSyntaxException();
		}

	}

	private double parseE(String expression) throws IncorrectSyntaxException{
		//E = (E O E)
		//Take advantage that parseS parses E O E
		if (expression.charAt(0) == '(' && expression.charAt(expression.length()-1) == ')'){
			return parseS(expression.substring(1,expression.length()-1).trim());
		}
		//E = # | -#
		try{
			return Double.valueOf(expression.trim());
		}catch(NumberFormatException e){
			throw new IncorrectSyntaxException();
		}
	}

	class IncorrectSyntaxException extends Exception{}
}
