import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;

/**
 * Goal: move the disks from A to C.
 * You have B as an intermediate pole.
 * @author Christie
 *
 */
public class Hanoi {
	private int numDisks;
	private Tower aTower, bTower, cTower;
	/**
	 * Constructor.
	 * @param numDisks
	 */
	public Hanoi(int numDisks){
		this.numDisks = numDisks;
		//Ignore this--it's implementation details we'll go into later.
		aTower = new Tower("A", numDisks);
		bTower = new Tower("B", numDisks);
		cTower = new Tower("C", numDisks);
		//put the disks on aPole.
		for (int i = numDisks; i>0; i--){
			//pushes an item on the top of the stack.
			aTower.push(i);
		}
		hanoi(numDisks,aTower,cTower,bTower);
	}
	
	/**
	 * The basic canonical recursive solution to the Towers of Hanoi
	 * @param height
	 * @param fromPole
	 * @param toPole
	 * @param whichPole
	 */
	public void hanoi(int height, Tower sourceT, Tower destT, Tower helperT){
		if (height < 1) {
			//base case
			//System.out.println("Done!");
		}
		else {
           hanoi(height-1, sourceT, helperT, destT); //recursive call
           moveDisk(sourceT, destT);
           hanoi(height-1, helperT, destT, sourceT); //recursive call
        }
	}
	
	/**
	 * Count the number of moves, and print out moves that are "happening"
	 * @param fromPole
	 * @param toPole
	 */
	public void moveDisk(Tower src, Tower dst){
		//numMoves++;
		int disk = src.remove();
		dst.push(disk);
		System.out.println("Moving disk "+disk+" from " + src.toString() + " to " + dst.toString());
		System.out.println(this.toString());
	}
	/**
	 * ToString--tower.
	 */
	public String toString(){
		String[] a = aTower.getSingleStackString();
		String[] b = bTower.getSingleStackString();
		String[] c = cTower.getSingleStackString();
		String s = "";
		for(int i = 0; i<a.length; i++){
			s+= a[i]+"\t"+b[i]+"\t"+c[i]+"\n";
		}
		return s;
	}
	
	/**
	 * Main method to solve puzzles with height given as a cmd line argument.
	 * It is assumed we're moving all disks from A --> C
	 * @param args
	 *
	 */
	public static void main(String[] args){
		Hanoi h = new Hanoi(5);
       System.out.println("All Disks have been moved!");
	}
	
}

/**
 * Basically, ignore this class--treat it as a black box.
 * It handles a lot of the nasty implementation details of printing
 * pretty and uses a stack
 * @author Christie
 *
 */
class Tower{
	private String name, blankString, diskString;
	private int maxNumDisks;
	//A stack is exactly what you think it is:
	//you have access to the top of the stack--you can only look at the
	//top element, and pop it off the top of the stack.
	private Stack<Integer> tower;
	public Tower(String name, int numDisks){
		this.name = name;
		maxNumDisks = numDisks;
		blankString = "";
		diskString = "";
		for (int i = 0; i<numDisks; i++){
			blankString +=" ";
			diskString +="-";
		}
		//Ignore this--it's implementation details we'll go into later.
		tower = new Stack<Integer>();
	}
	public void push(int i)
	{
		tower.push(i);
	}
	public int remove()
	{
		return tower.pop();
	}
	public String toString()
	{
		return this.name;
	}
	/**
	 * Printing function--ignore it's implementation details,
	 *  it's just for demo.
	 * @param tower
	 * @return
	 */
	public String[] getSingleStackString()
	{
		String[] ss = new String[maxNumDisks];
		int ind = maxNumDisks-1;
		for (Integer t : tower){
			ss[ind] = blankString.substring(0,maxNumDisks-t)+diskString.substring(0,t) +"|"
						+diskString.substring(0,t)+blankString.substring(0,maxNumDisks-t);
			ind--;
		}
		while(ind >=0){
			ss[ind]=blankString+"|"+blankString;
			ind --;
		}
		return ss;
	}
}