
import java.util.Random;

import javax.swing.JFrame;

import com.mxgraph.layout.mxCompactTreeLayout;
import com.mxgraph.layout.mxFastOrganicLayout;
import com.mxgraph.layout.mxGraphLayout;
import com.mxgraph.model.mxCell;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.view.mxGraph;

public class Graphlet extends JFrame
{
	private mxGraph graph;
	private Object parent;
	private mxGraphLayout layout;
	private Chamber currChamber;
	/**
	 * 
	 */
	private static final long serialVersionUID = -2707712944901661771L;

	private Object drawChambers(Chamber c)
	{
		Chamber[] chs = c.getChambers();
		String ttl = c.getName();
		if (c.isExit())
			ttl+= "\nEXIT!";
		Object v1 = graph.insertVertex(parent, c.getName(), ttl, 0,0, 30,30);
		c.setCell(v1);
		if (c.isExit())
			((mxCell)v1).setStyle("strokeColor=black;fillColor=yellow");
		else
			((mxCell)v1).setStyle("strokeColor=black;fillColor=white");
		if (chs!=null)
		{
			for (Chamber c2:chs)
			{
				Object v2 = drawChambers(c2);
				graph.insertEdge(parent, null, "", v1, v2);
			}
			
		}
		return v1;
	}
	public Graphlet(Chamber c)
	{
		super("Cave");
		graph = new mxGraph();
		parent = graph.getDefaultParent();
		graph.getModel().beginUpdate();
		try
		{
			//Object v1 = graph.insertVertex(parent, null, "Hello", 20, 20, 80,30);
			//Object v2 = graph.insertVertex(parent, null, "World!", 240, 150,80, 30);
			//graph.insertEdge(parent, null, "Edge", v1, v2);
			Object root = drawChambers(c);
			this.currChamber = c;
			((mxCell)root).setStyle("strokeColor=white;fillColor=green");
			layout = new mxCompactTreeLayout(graph);//mxFastOrganicLayout(graph);
			layout.execute(parent);
		}
		finally
		{
			graph.getModel().endUpdate();
		}

		mxGraphComponent graphComponent = new mxGraphComponent(graph);
		getContentPane().add(graphComponent);
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		this.setSize(400, 320);
		this.setVisible(true);
	}
	public void movePerson(Chamber cTo)
	{
		graph.getModel().beginUpdate();
		((mxCell)currChamber.getCell()).setStyle("strokeColor=black;fillColor=white");
		((mxCell)cTo.getCell()).setStyle("strokeColor=white;fillColor=green");
		currChamber = cTo;
		graph.getModel().endUpdate();
		graph.repaint();
		graph.refresh();
		this.repaint();
		this.setVisible(true);
		//I'm handling the exception here because this is the proper "owner" of this exception.
		//if a problem happens with putting the thread to sleep, I just want it to continue;
		//I don't want the caller method to know about it.
		try{
		Thread.currentThread().sleep(1000);
		}
		catch(Exception e)
		{
			System.out.println(e.getMessage());
		}
	}



}
