public class SumThread extends Thread {
	int[] array;
	int from, to;
	int sum;
	
	SumThread(int[] array, int from, int to) {
		this.array = array;
		this.from = from;
		this.to = to;
	}
	
	public int getSum() { return sum; }
	
	public void run() {
		sum = 0;
		for (int i=from; i<=to; i++) sum += array[i];
	}
	
	public static void main(String[] args) {
		int n = 10000; //1 * 1000 * 1000;
		int[] array = new int[n];
		for (int i=0; i<n; i++) array[i] = i+1;

		int t = 16;
		SumThread[] threads = new SumThread[t];
		int blockSize = n / t;
		for (int i=0; i<t; i++)
			threads[i] = new SumThread(array,i*blockSize,(i+1)*blockSize-1);
		
		for (int i=0; i<t; i++) threads[i].start();

		int totalSum = 0;
		// wait for all threads to finish
		try {
			for (int i=0; i<n; i++) {
				threads[i].join();
				int sum = threads[i].getSum();
				totalSum += sum;
			}
		}
		catch (Exception e) {
			System.out.println(e.getMessage());
		}
		
		System.out.println("total sum = " + totalSum);
	}
}
