import java.util.concurrent.Semaphore;

public class Philosopher extends Thread {
	Semaphore[] chopsticks;
	int position;
	int n, c;
	
	Philosopher(Semaphore[] sticks, int p, int n, int c) {
		chopsticks = sticks;
		position = p;
		this.n = n;
		this.c = c;
	}
	
	public void run() {
		int left = position - 1;
		if (left < 0) left += n;
		int right = position + 1;
		if (right >= n) right -= n;
		
		for (int i=0; i<c; i++) {
			try {
				// pick up chopstick on the left
				chopsticks[left].acquire();		
				// pick up chopstick on the right
				chopsticks[right].acquire();
			}
			catch (InterruptedException e) {
				System.out.println(e.getMessage());
				return;
			}

			// eat
			System.out.println("Philosopher " + position + " is eating.");

			// put down chopstick on the right
			chopsticks[right].release();
			// put down chopstick on the left
			chopsticks[left].release();
		}
	}
	
	public static void main(String[] args) {
		int n = 5; // number of philosophers and chopsticks
		int c = 2; // how many times each philosopher wants to eat

		Semaphore[] sticks = new Semaphore[n];
		for (int i=0; i<n; i++) sticks[i] = new Semaphore(1);
		
		Philosopher[] phil = new Philosopher[n];
		for (int i=0; i<n; i++)
			phil[i] = new Philosopher(sticks,i,n,c);

		for (int i=0; i<n; i++)
			phil[i].start();
	}
}
